/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.client.gui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import net.gegy1000.earth.Earth;
import net.gegy1000.earth.google.geocode.ReverseGeoCode;
import net.gegy1000.earth.google.streetview.StreetView;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class GuiStreetView
extends GuiScreen {
    private DynamicTexture dynamicTexture;
    private ResourceLocation location;
    private BufferedImage image;
    private double latitude;
    private double longitude;
    private String address;

    public GuiStreetView(final EntityPlayer player) {
        this.latitude = Earth.generator.toLat(player.field_70161_v);
        this.longitude = Earth.generator.toLong(player.field_70165_t);
        Thread downloadThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StreetView streetView = StreetView.get(GuiStreetView.this.latitude, GuiStreetView.this.longitude, player.field_70177_z - 180.0f, -player.field_70125_A);
                    GuiStreetView.this.image = streetView.getImage();
                    GuiStreetView.this.address = ReverseGeoCode.get(GuiStreetView.this.latitude, GuiStreetView.this.longitude).getFormattedAddress();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        downloadThread.start();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_146276_q_();
        ScaledResolution scaledResolution = new ScaledResolution(this.field_146297_k);
        int scaledWidth = scaledResolution.func_78326_a();
        int scaledHeight = scaledResolution.func_78328_b();
        if (this.dynamicTexture == null) {
            if (this.image != null) {
                this.dynamicTexture = new DynamicTexture(this.image);
                this.location = this.field_146297_k.func_110434_K().func_110578_a("streetview_image", this.dynamicTexture);
            }
            this.field_146289_q.func_175063_a("Downloading Image...", 10.0f, 10.0f, 0xFF0000);
        } else {
            this.field_146289_q.func_175063_a("Location: Lat: " + this.latitude + ", Long: " + this.longitude, 5.0f, 5.0f, 0xFF0000);
            this.field_146289_q.func_175063_a(this.address, 5.0f, 15.0f, 65535);
            this.field_146297_k.func_110434_K().func_110577_a(this.location);
            double scaleX = (double)scaledWidth / 640.0 * 0.8;
            double scaleY = (double)scaledHeight / 320.0 * 0.8;
            this.drawTexturedModalRect((int)((double)(scaledWidth / 2) - 640.0 * scaleX / 2.0), (int)((double)(scaledHeight / 2) - 320.0 * scaleY / 2.0), 0, 0, 640, 320, 640, 320, scaleX, scaleY);
        }
    }

    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int texWidth, int texHeight, double scaleX, double scaleY) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)scaleX, (double)scaleY, (double)0.0);
        x = (int)((double)x / scaleX);
        y = (int)((double)y / scaleY);
        float f = 1.0f / (float)texWidth;
        float f1 = 1.0f / (float)texHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_181673_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_181673_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_181673_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_181673_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.field_146297_k.func_110434_K().func_147645_c(this.location);
    }

    public boolean func_73868_f() {
        return false;
    }
}

