/*
 * Decompiled with CFR 0.152.
 */
package twilightsparkle.basic.mob;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightsparkle.basic.Basic;
import twilightsparkle.basic.mob.BetterFireball;
import twilightsparkle.basic.mob.FireCannon;
import twilightsparkle.basic.mob.GenericTargetSorter;
import twilightsparkle.basic.mob.MySkull;

public class MySkullBoss
extends EntityMob
implements IMob {
    private ChunkCoordinates currentFlightTarget = null;
    private int lastX = 0;
    private int lastZ = 0;
    private int lastY = 0;
    private int stuck_count = 0;
    private GenericTargetSorter TargetSorter = null;
    private float moveSpeed = 0.35f;
    private int dmgDelay = 0;
    private int boatPosRotationIncrements;
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
    private double boatYawHead;

    public MySkullBoss(World par1World) {
        super(par1World);
        this.func_70105_a(3.0f, 4.0f);
        this.func_70661_as().func_75491_a(true);
        this.field_70728_aV = 1000;
        this.field_70178_ae = true;
        this.TargetSorter = new GenericTargetSorter((Entity)this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.mygetMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.moveSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected boolean func_70692_ba() {
        return !this.func_104002_bU();
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public int func_70658_aO() {
        return 18;
    }

    public int getMothraHealth() {
        return (int)this.func_110143_aJ();
    }

    protected float func_70599_aP() {
        return 1.5f;
    }

    protected float func_70647_i() {
        return 1.0f;
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return null;
    }

    protected String func_70673_aS() {
        return "random.explode";
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity par1Entity) {
    }

    protected void func_85033_bc() {
    }

    public int mygetMaxHealth() {
        return 550;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70170_p.func_72869_a("flame", this.field_70165_t, this.field_70163_u + 1.25, this.field_70161_v, (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) / 2.0f), (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) / 2.0f), (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) / 2.0f));
        this.field_70170_p.func_72869_a("flame", this.field_70165_t, this.field_70163_u + 1.25, this.field_70161_v, (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) / 2.0f), (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) / 2.0f), (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) / 2.0f));
        this.field_70170_p.func_72869_a("flame", this.field_70165_t, this.field_70163_u + 1.25, this.field_70161_v, (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) / 2.0f), (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) / 2.0f), (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) / 2.0f));
        this.field_70181_x *= 0.4;
        if (this.func_110143_aJ() < (float)this.mygetMaxHealth() && this.field_70170_p.field_73012_v.nextInt(5) == 1) {
            this.func_70691_i(1.0f);
        }
    }

    public boolean canSeeTarget(double pX, double pY, double pZ) {
        return this.field_70170_p.func_72901_a(Vec3.func_72443_a((double)this.field_70165_t, (double)(this.field_70163_u + 0.75), (double)this.field_70161_v), Vec3.func_72443_a((double)pX, (double)pY, (double)pZ), false) == null;
    }

    protected void func_70619_bc() {
        int xdir = 1;
        int zdir = 1;
        int keep_trying = 50;
        if (this.dmgDelay > 0) {
            --this.dmgDelay;
        }
        int shoot = 2;
        if (this.field_70128_L) {
            return;
        }
        super.func_70619_bc();
        if (this.field_70170_p.field_72995_K && this.boatPosRotationIncrements > 0) {
            double d4 = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
            double d5 = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
            double d11 = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
            this.func_70107_b(d4, d5, d11);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
            double d10 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
            if (this.field_70153_n != null) {
                d10 = MathHelper.func_76138_g((double)(this.field_70153_n.field_70177_z - this.field_70177_z));
            }
            this.field_70177_z = (float)((double)this.field_70177_z + d10 / (double)this.boatPosRotationIncrements);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70177_z;
            --this.boatPosRotationIncrements;
        }
        if (this.lastX == (int)this.field_70165_t && this.lastY == (int)this.field_70163_u && this.lastZ == (int)this.field_70161_v) {
            ++this.stuck_count;
        } else {
            this.stuck_count = 0;
            this.lastX = (int)this.field_70165_t;
            this.lastY = (int)this.field_70163_u;
            this.lastZ = (int)this.field_70161_v;
        }
        if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
            shoot = 1;
        }
        if (this.currentFlightTarget == null) {
            this.currentFlightTarget = new ChunkCoordinates((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
        if (this.stuck_count > 2 || this.field_70170_p.field_73012_v.nextInt(300) == 0 || this.currentFlightTarget.func_71569_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 9.0f) {
            int down = 0;
            int dist = 3;
            for (int i = -5; i <= 5; i += 5) {
                block1: for (int j = -5; j <= 5; j += 5) {
                    for (int k = 1; k < 20; ++k) {
                        Block bid = this.field_70170_p.func_147439_a((int)this.field_70165_t + j, (int)this.field_70163_u - k, (int)this.field_70161_v + i);
                        if (bid == Blocks.field_150350_a) continue;
                        if (k >= dist) continue block1;
                        dist = k;
                        continue block1;
                    }
                }
            }
            if (dist > 10) {
                down = dist - 5 + 1;
            }
            Block bid = Blocks.field_150348_b;
            while (bid != Blocks.field_150350_a && keep_trying != 0) {
                xdir = 1;
                zdir = 1;
                if (this.field_70146_Z.nextInt(2) == 0) {
                    xdir = -1;
                }
                if (this.field_70146_Z.nextInt(2) == 0) {
                    zdir = -1;
                }
                int newz = this.field_70146_Z.nextInt(20) + 16;
                int newx = this.field_70146_Z.nextInt(20) + 16;
                this.currentFlightTarget.func_71571_b((int)this.field_70165_t + (newx *= xdir), (int)this.field_70163_u + this.field_70146_Z.nextInt(7) - 1 - down, (int)this.field_70161_v + (newz *= zdir));
                bid = this.field_70170_p.func_147439_a(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c);
                if (bid == Blocks.field_150350_a && !this.canSeeTarget(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c)) {
                    bid = Blocks.field_150348_b;
                }
                --keep_trying;
            }
            this.stuck_count = 0;
        } else if (this.field_70170_p.field_73012_v.nextInt(10) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntityPlayer target = null;
            target = (EntityPlayer)this.field_70170_p.func_72857_a(EntityPlayer.class, this.field_70121_D.func_72314_b(65.0, 30.0, 65.0), (Entity)this);
            if (target != null) {
                if (!target.field_71075_bZ.field_75098_d) {
                    if (this.func_70635_at().func_75522_a((Entity)target)) {
                        this.currentFlightTarget.func_71571_b((int)target.field_70165_t, (int)target.field_70163_u, (int)target.field_70161_v);
                        if (this.field_70170_p.field_73012_v.nextInt(4) == 1 || this.field_70170_p.field_73012_v.nextInt(5) == 1) {
                            this.firecanon((EntityLivingBase)target);
                            this.MeteorStrike((EntityLivingBase)target);
                        }
                    }
                } else {
                    target = null;
                }
            }
            if (target == null && this.field_70170_p.field_73012_v.nextInt(3) == 0) {
                EntityLivingBase e = null;
                EntityLivingBase f = null;
                f = this.findSomethingToAttack();
                if (e == null) {
                    e = f;
                }
                if ((e = this.findSomethingToAttack()) != null) {
                    if (this.func_70068_e((Entity)e) < (double)((35.0f + e.field_70130_N / 2.0f) * (35.0f + e.field_70130_N / 2.0f))) {
                        if (this.field_70170_p.field_73012_v.nextInt(5) == 1 || this.field_70170_p.field_73012_v.nextInt(6) == 1) {
                            this.firecanon(e);
                            this.MeteorStrike(e);
                        }
                        if (this.func_70068_e((Entity)e) < (double)((15.0f + e.field_70130_N / 2.0f) * (15.0f + e.field_70130_N / 2.0f))) {
                            int down = 0;
                            int newz = this.field_70146_Z.nextInt(5) + 6;
                            int newx = this.field_70146_Z.nextInt(5) + 6;
                            this.currentFlightTarget.func_71571_b((int)this.field_70165_t + (newx *= xdir), (int)this.field_70163_u + this.field_70146_Z.nextInt(3) - 1 - down, (int)this.field_70161_v + (newz *= zdir));
                        }
                    }
                    this.currentFlightTarget.func_71571_b((int)e.field_70165_t, (int)e.field_70163_u + 5, (int)e.field_70161_v);
                    this.firecanon(e);
                    this.MeteorStrike(e);
                    if (this.func_70068_e((Entity)e) < (double)((5.0f + e.field_70130_N / 2.0f) * (5.0f + e.field_70130_N / 2.0f))) {
                        this.func_70652_k((Entity)e);
                    }
                }
            }
        }
        double var1 = (double)this.currentFlightTarget.field_71574_a + 0.5 - this.field_70165_t;
        double var3 = (double)this.currentFlightTarget.field_71572_b + 0.1 - this.field_70163_u;
        double var5 = (double)this.currentFlightTarget.field_71573_c + 0.5 - this.field_70161_v;
        this.field_70159_w += (Math.signum(var1) * 0.5 - this.field_70159_w) * 0.30001;
        this.field_70181_x += (Math.signum(var3) * 0.7 - this.field_70181_x) * 0.20001;
        this.field_70179_y += (Math.signum(var5) * 0.5 - this.field_70179_y) * 0.30001;
        float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
        float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
        this.field_70701_bs = 0.8f;
        this.field_70177_z += var8 / 16.0f;
    }

    public boolean func_70652_k(Entity par1Entity) {
        double ks = 2.0;
        double inair = -0.25;
        int var2 = 6;
        if (super.func_70652_k(par1Entity)) {
            if (par1Entity != null && par1Entity instanceof EntityLivingBase) {
                if (this.field_70170_p.field_73013_u == EnumDifficulty.EASY) {
                    var2 = 8;
                    if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                        var2 = 10;
                    } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                        var2 = 12;
                    }
                }
                if (this.field_70170_p.field_73012_v.nextInt(3) == 1) {
                    // empty if block
                }
                float f3 = (float)Math.atan2(par1Entity.field_70161_v - this.field_70161_v, par1Entity.field_70165_t - this.field_70165_t);
                if (par1Entity.field_70128_L || par1Entity instanceof EntityPlayer) {
                    inair *= 2.0;
                }
                par1Entity.func_70024_g(Math.cos(f3) * ks, inair, Math.sin(f3) * ks);
            }
            return true;
        }
        return false;
    }

    private void MeteorStrike(EntityLivingBase e) {
        FireCannon var2;
        double yoff = -3.5;
        double xzoff = 1.5;
        if (this.field_70146_Z.nextInt(30) == 1) {
            var2 = new FireCannon(this.field_70170_p, e.field_70165_t - this.field_70165_t, e.field_70163_u + 0.75 - (this.field_70163_u + yoff), e.field_70161_v - this.field_70161_v);
            var2.func_70012_b(this.field_70165_t - xzoff * Math.sin(Math.toRadians(this.field_70759_as)), this.field_70163_u + yoff, this.field_70161_v + xzoff * Math.cos(Math.toRadians(this.field_70759_as)), this.field_70177_z, this.field_70125_A);
            this.field_70170_p.func_72956_a((Entity)this, "random.bow", 0.75f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)var2);
        }
        var2 = new FireCannon(this.field_70170_p, e.field_70165_t - this.field_70165_t, e.field_70163_u + 0.75 - (this.field_70163_u + yoff), e.field_70161_v - this.field_70161_v);
        var2.func_70012_b(this.field_70165_t - xzoff * Math.sin(Math.toRadians(this.field_70759_as)), this.field_70163_u + yoff, this.field_70161_v + xzoff * Math.cos(Math.toRadians(this.field_70177_z)), this.field_70759_as, this.field_70125_A);
        double var3 = e.field_70165_t - var2.field_70165_t;
        double var5 = e.field_70163_u + 0.25 - var2.field_70163_u;
        double var7 = e.field_70161_v - var2.field_70161_v;
        float var9 = MathHelper.func_76133_a((double)(var3 * var3 + var7 * var7)) * 0.2f;
        var2.func_70186_c(var3, var5 + (double)var9, var7, 1.4f, 5.0f);
        this.field_70170_p.func_72956_a((Entity)this, "random.explode", 0.75f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)var2);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean ret = false;
        Entity e = par1DamageSource.func_76346_g();
        if (e != null && e instanceof MySkullBoss) {
            return false;
        }
        if (this.dmgDelay > 0) {
            return false;
        }
        float dm = par2;
        if (!par1DamageSource.func_76355_l().equals("explosion")) {
            dm = 0.0f;
        }
        if (!par1DamageSource.func_76355_l().equals("cactus")) {
            ret = super.func_70097_a(par1DamageSource, par2);
            this.dmgDelay = 15;
        }
        ret = super.func_70097_a(par1DamageSource, par2);
        if (e != null && this.currentFlightTarget != null) {
            this.currentFlightTarget.func_71571_b((int)e.field_70165_t, (int)e.field_70163_u + 2, (int)e.field_70161_v);
        }
        return ret;
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
    }

    public boolean func_70601_bi() {
        Block bid;
        int i;
        int j;
        int k;
        for (k = -4; k <= 4; ++k) {
            for (j = -4; j <= 4; ++j) {
                for (i = 1; i < 4; ++i) {
                    bid = this.field_70170_p.func_147439_a((int)this.field_70165_t + j, (int)this.field_70163_u + i, (int)this.field_70161_v + k);
                    if (bid != Blocks.field_150474_ac) continue;
                    TileEntityMobSpawner tileentitymobspawner = null;
                    tileentitymobspawner = (TileEntityMobSpawner)this.field_70170_p.func_147438_o((int)this.field_70165_t + j, (int)this.field_70163_u + i, (int)this.field_70161_v + k);
                    String s = tileentitymobspawner.func_145881_a().func_98276_e();
                    if (s == null || !s.equals("BigBadSkull")) continue;
                    return true;
                }
            }
        }
        for (k = -4; k < 4; ++k) {
            for (j = -3; j < 3; ++j) {
                for (i = 1; i < 10; ++i) {
                    bid = this.field_70170_p.func_147439_a((int)this.field_70165_t + j, (int)this.field_70163_u + i, (int)this.field_70161_v + k);
                    if (bid == Blocks.field_150350_a) continue;
                    return false;
                }
            }
        }
        MySkullBoss target = null;
        target = (MySkullBoss)this.field_70170_p.func_72857_a(MySkullBoss.class, this.field_70121_D.func_72314_b(64.0, 32.0, 64.0), (Entity)this);
        return target == null;
    }

    public void initCreature() {
    }

    private ItemStack dropItemRand(Item index, int par1) {
        EntityItem var3 = null;
        ItemStack is = new ItemStack(index, par1, 0);
        var3 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), this.field_70163_u + 1.0, this.field_70161_v + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), is);
        float f3 = (float)Math.atan2((double)Basic.TwilightRand2.nextInt() - this.field_70161_v, (double)Basic.TwilightRand2.nextInt() - this.field_70165_t);
        var3.func_70024_g(Math.cos(f3) * 0.25, (double)0.45f, Math.sin(f3) * 0.25);
        if (var3 != null) {
            this.field_70170_p.func_72838_d((Entity)var3);
        }
        return is;
    }

    private ItemStack dropBlockRand(Block index, int par1) {
        EntityItem var3 = null;
        ItemStack is = new ItemStack(index, par1, 0);
        var3 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), this.field_70163_u + 1.0, this.field_70161_v + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), is);
        float f3 = (float)Math.atan2((double)Basic.TwilightRand2.nextInt() - this.field_70161_v, (double)Basic.TwilightRand2.nextInt() - this.field_70165_t);
        var3.func_70024_g(Math.cos(f3) * 0.25, (double)0.45f, Math.sin(f3) * 0.25);
        if (var3 != null) {
            this.field_70170_p.func_72838_d((Entity)var3);
        }
        return is;
    }

    protected void func_70628_a(boolean par1, int par2) {
        int var4;
        int i = 8 + this.field_70170_p.field_73012_v.nextInt(6);
        for (var4 = 0; var4 < i; ++var4) {
            this.dropBlockRand(Basic.boneBrick, 5);
        }
        i = 16 + this.field_70170_p.field_73012_v.nextInt(6);
        for (var4 = 0; var4 < i; ++var4) {
            this.dropBlockRand(Basic.boneOre, 8);
        }
        i = 2 + this.field_70170_p.field_73012_v.nextInt(6);
        for (var4 = 0; var4 < i; ++var4) {
            this.dropBlockRand(Basic.boneWall, 4);
        }
        if (this.field_70170_p.field_73012_v.nextInt(5) == 1) {
            this.dropItemRand(Basic.bowserBone, 5);
        }
        if (this.field_70170_p.field_73012_v.nextInt(5) == 1) {
            this.dropItemRand(Basic.phoenixFeather, 3);
        }
        if (this.field_70170_p.field_73012_v.nextInt(5) == 1) {
            this.dropBlockRand((Block)Blocks.field_150480_ab, 15);
        }
    }

    private void firecanon(EntityLivingBase e) {
        double yoff = -0.5;
        double xzoff = 3.0;
        BetterFireball bf = null;
        double cx = this.field_70165_t - xzoff * Math.sin(Math.toRadians(this.field_70177_z));
        double cz = this.field_70161_v + xzoff * Math.cos(Math.toRadians(this.field_70177_z));
        float r1 = 5.0f * (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat());
        float r2 = 3.0f * (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat());
        float r3 = 5.0f * (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat());
        bf = new BetterFireball(this.field_70170_p, (EntityLivingBase)this, e.field_70165_t - cx + (double)r1, e.field_70163_u + (double)(e.field_70131_O / 2.0f) - (this.field_70163_u + yoff) + (double)r2, e.field_70161_v - cz + (double)r3);
        bf.func_70012_b(cx, this.field_70163_u + yoff, cz, this.field_70177_z, 0.0f);
        bf.func_70107_b(cx, this.field_70163_u + yoff, cz);
        bf.setBowser();
        this.field_70170_p.func_72956_a((Entity)this, "kingbowsermod:slap", 3.0f, 1.0f);
        this.field_70170_p.func_72838_d((Entity)bf);
        this.func_70691_i(5.0f);
    }

    private boolean isSuitableTarget(EntityLivingBase par1EntityLiving, boolean par2) {
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (par1EntityLiving == null) {
            return false;
        }
        if (par1EntityLiving == this) {
            return false;
        }
        if (!par1EntityLiving.func_70089_S()) {
            return false;
        }
        if (!this.func_70635_at().func_75522_a((Entity)par1EntityLiving)) {
            return false;
        }
        if (par1EntityLiving instanceof MySkullBoss) {
            return false;
        }
        if (par1EntityLiving instanceof MySkull) {
            return false;
        }
        if (par1EntityLiving instanceof EntityGhast) {
            return false;
        }
        if (par1EntityLiving instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)par1EntityLiving;
            if (p.field_71075_bZ.field_75098_d) {
                return false;
            }
        }
        return true;
    }

    private EntityLivingBase findSomethingToAttack() {
        List var5 = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(65.0, 30.0, 65.0));
        Collections.sort(var5, this.TargetSorter);
        Iterator var2 = var5.iterator();
        Entity var3 = null;
        EntityLivingBase var4 = null;
        while (var2.hasNext()) {
            var3 = (Entity)var2.next();
            var4 = (EntityLivingBase)var3;
            if (!this.isSuitableTarget(var4, false)) continue;
            return var4;
        }
        return null;
    }
}

