/*
 * Decompiled with CFR 0.152.
 */
package twilightsparkle.basic.mob;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightsparkle.basic.Basic;
import twilightsparkle.basic.mob.GenericTargetSorter;
import twilightsparkle.basic.mob.MobUtils;

public class MyLeviathan
extends EntityMob {
    private ChunkCoordinates currentFlightTarget = null;
    private GenericTargetSorter TargetSorter = null;
    private int winded = 0;
    private int busy_fighting = 0;
    private int was_spawnered = 0;

    public MyLeviathan(World par1World) {
        super(par1World);
        this.func_70105_a(8.0f, 4.0f);
        this.field_70728_aV = 600;
        this.field_70178_ae = true;
        this.field_70174_ab = 250;
        this.field_70155_l = 12.0;
        this.func_70072_I();
        this.func_70648_aU();
        this.TargetSorter = new GenericTargetSorter((Entity)this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.mygetMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.35f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected float func_70599_aP() {
        return 1.75f;
    }

    protected float func_70647_i() {
        return 4.0f;
    }

    protected String func_70639_aQ() {
        return "mob.enderdragon.growl";
    }

    protected String func_70621_aR() {
        return "mob.enderdragon.hit";
    }

    protected String func_70673_aS() {
        return "mob.enderdragon.hit";
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity par1Entity) {
    }

    public int mygetMaxHealth() {
        return 990;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public void func_70071_h_() {
        int i;
        EntityLivingBase e = null;
        super.func_70071_h_();
        for (i = 0; i < 40; ++i) {
            float var1 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float var2 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float var3 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)var1, this.field_70163_u + 2.0 + (double)var2, this.field_70161_v + (double)var3, 0.0, 0.75, 0.0);
        }
        this.field_70181_x *= 0.6;
        this.busy_fighting = 0;
        e = this.findSomethingToAttack();
        if (e != null) {
            this.busy_fighting = 1;
            if (this.field_70170_p.field_72995_K) {
                for (i = 0; i < 20; ++i) {
                    double d = this.field_70170_p.field_73012_v.nextDouble() * 3.5;
                    d *= d;
                    double dir = this.field_70170_p.field_73012_v.nextDouble() * 2.0 * Math.PI;
                    double dx = Math.cos(dir -= Math.PI) * d / 2.0;
                    double dz = Math.sin(dir) * d / 2.0;
                    dir += 1.570796326794897;
                }
            }
        }
        if (this.field_70170_p.field_73012_v.nextInt(100) == 1) {
            this.func_70691_i(10.0f);
        }
    }

    public boolean canSeeTarget(double pX, double pY, double pZ) {
        return this.field_70170_p.func_72901_a(Vec3.func_72443_a((double)this.field_70165_t, (double)(this.field_70163_u + 0.75), (double)this.field_70161_v), Vec3.func_72443_a((double)pX, (double)pY, (double)pZ), false) == null;
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (super.func_70652_k(par1Entity)) {
            if (par1Entity != null && par1Entity instanceof EntityLivingBase) {
                double ks = 0.2;
                double inair = -0.2;
                float f3 = (float)Math.atan2(par1Entity.field_70161_v - this.field_70161_v, par1Entity.field_70165_t - this.field_70165_t);
                if (par1Entity.field_70128_L || par1Entity instanceof EntityPlayer) {
                    inair *= 2.0;
                }
                par1Entity.func_70024_g(Math.cos(f3) * ks, inair, Math.sin(f3) * ks);
            }
            return true;
        }
        return false;
    }

    protected void func_70619_bc() {
        int xdir = 1;
        int zdir = 1;
        int keep_trying = 50;
        EntityLivingBase e = null;
        if (this.field_70128_L) {
            return;
        }
        super.func_70619_bc();
        if (this.currentFlightTarget == null) {
            this.currentFlightTarget = new ChunkCoordinates((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
        if (this.winded > 0) {
            --this.winded;
        }
        if (this.field_70146_Z.nextInt(300) == 0 || this.currentFlightTarget.func_71569_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 2.1f) {
            Block bid = Blocks.field_150348_b;
            while (bid != Blocks.field_150350_a && keep_trying != 0) {
                zdir = this.field_70146_Z.nextInt(14) + 10;
                xdir = this.field_70146_Z.nextInt(14) + 10;
                if (this.field_70146_Z.nextInt(2) == 0) {
                    zdir = -zdir;
                }
                if (this.field_70146_Z.nextInt(2) == 0) {
                    xdir = -xdir;
                }
                this.currentFlightTarget.func_71571_b((int)this.field_70165_t + xdir, (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 3, (int)this.field_70161_v + zdir);
                bid = this.field_70170_p.func_147439_a(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c);
                if (bid == Blocks.field_150350_a && !this.canSeeTarget(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c)) {
                    bid = Blocks.field_150348_b;
                }
                --keep_trying;
            }
        }
        if ((e = this.findSomethingToAttack()) != null) {
            this.currentFlightTarget.func_71571_b((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v);
            double d = this.func_70068_e((Entity)e);
            if (d < 181.0) {
                double a = Math.atan2(this.field_70161_v - e.field_70161_v, this.field_70165_t - e.field_70165_t);
                double pm = 1.0;
                if (e instanceof EntityPlayer) {
                    pm = 2.0;
                }
                e.func_70024_g(Math.cos(a) * (20.0 - Math.sqrt(d)) * 0.1000000014901161, (20.0 - Math.sqrt(d)) * 0.0500000007450581 * pm, Math.sin(a) * (20.0 - Math.sqrt(d)) * 0.1000000014901161);
            }
            if (this.func_70068_e((Entity)e) < (double)((10.0f + e.field_70130_N / 2.0f) * (10.0f + e.field_70130_N / 2.0f)) && this.field_70146_Z.nextInt(3) == 1 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
                this.func_70652_k((Entity)e);
            }
        }
        double var1 = (double)this.currentFlightTarget.field_71574_a + 0.5 - this.field_70165_t;
        double var3 = (double)this.currentFlightTarget.field_71572_b + 0.1 - this.field_70163_u;
        double var5 = (double)this.currentFlightTarget.field_71573_c + 0.5 - this.field_70161_v;
        this.field_70159_w += (Math.signum(var1) * 0.4 - this.field_70159_w) * 0.2;
        this.field_70181_x += (Math.signum(var3) * (double)0.7f - this.field_70181_x) * 0.2000000014901161;
        this.field_70179_y += (Math.signum(var5) * 0.4 - this.field_70179_y) * 0.2;
        float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
        float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
        this.field_70701_bs = 0.75f;
        this.field_70177_z += var8 / 4.0f;
    }

    protected boolean func_70041_e_() {
        return true;
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean ret = false;
        Entity e = par1DamageSource.func_76346_g();
        ret = super.func_70097_a(par1DamageSource, par2);
        if (e != null && this.currentFlightTarget != null) {
            this.currentFlightTarget.func_71571_b((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v);
        }
        this.winded = 20;
        return ret;
    }

    public int func_70658_aO() {
        return 20;
    }

    private boolean isSuitableTarget(EntityLivingBase par1EntityLiving, boolean par2) {
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (par1EntityLiving == null) {
            return false;
        }
        if (par1EntityLiving == this) {
            return false;
        }
        if (!par1EntityLiving.func_70089_S()) {
            return false;
        }
        if (MobUtils.isIgnoreable(par1EntityLiving)) {
            return false;
        }
        if (!this.func_70635_at().func_75522_a((Entity)par1EntityLiving)) {
            return false;
        }
        if (par1EntityLiving instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)par1EntityLiving;
            if (p.field_71075_bZ.field_75098_d) {
                return false;
            }
        }
        if (par1EntityLiving instanceof MyLeviathan) {
            return false;
        }
        if (par1EntityLiving instanceof EntityZombie) {
            return false;
        }
        if (par1EntityLiving instanceof EntitySkeleton) {
            return false;
        }
        if (par1EntityLiving instanceof EntityEnderman) {
            return false;
        }
        if (par1EntityLiving instanceof EntityCreeper) {
            return false;
        }
        if (par1EntityLiving instanceof EntitySlime) {
            return false;
        }
        if (par1EntityLiving instanceof EntitySpider) {
            return false;
        }
        if (par1EntityLiving instanceof EntityWitch) {
            return false;
        }
        if (par1EntityLiving instanceof EntityBlaze) {
            return false;
        }
        if (par1EntityLiving instanceof EntityCaveSpider) {
            return false;
        }
        if (par1EntityLiving instanceof EntityGhast) {
            return false;
        }
        if (par1EntityLiving instanceof EntityGolem) {
            return false;
        }
        if (par1EntityLiving instanceof EntitySnowman) {
            return false;
        }
        if (par1EntityLiving instanceof EntityIronGolem) {
            return false;
        }
        if (par1EntityLiving instanceof EntityMagmaCube) {
            return false;
        }
        if (par1EntityLiving instanceof EntityCreature) {
            return false;
        }
        return !(par1EntityLiving instanceof EntityDragon);
    }

    private EntityLivingBase findSomethingToAttack() {
        if (Basic.Snap != 0) {
            return null;
        }
        List var5 = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(16.0, 10.0, 16.0));
        Collections.sort(var5, this.TargetSorter);
        Iterator var2 = var5.iterator();
        Entity var3 = null;
        EntityLivingBase var4 = null;
        while (var2.hasNext()) {
            var3 = (Entity)var2.next();
            var4 = (EntityLivingBase)var3;
            if (!this.isSuitableTarget(var4, false)) continue;
            return var4;
        }
        return null;
    }

    private ItemStack dropItemRand(Item index, int par1) {
        EntityItem var3 = null;
        ItemStack is = new ItemStack(index, par1, 0);
        var3 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), this.field_70163_u + 1.0, this.field_70161_v + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), is);
        float f3 = (float)Math.atan2((double)Basic.TwilightRand2.nextInt() - this.field_70161_v, (double)Basic.TwilightRand2.nextInt() - this.field_70165_t);
        var3.func_70024_g(Math.cos(f3) * 0.25, (double)0.45f, Math.sin(f3) * 0.25);
        if (var3 != null) {
            this.field_70170_p.func_72838_d((Entity)var3);
        }
        return is;
    }

    private ItemStack dropBlockRand(Block index, int par1) {
        EntityItem var3 = null;
        ItemStack is = new ItemStack(index, par1, 0);
        var3 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), this.field_70163_u + 1.0, this.field_70161_v + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), is);
        float f3 = (float)Math.atan2((double)Basic.TwilightRand2.nextInt() - this.field_70161_v, (double)Basic.TwilightRand2.nextInt() - this.field_70165_t);
        var3.func_70024_g(Math.cos(f3) * 0.25, (double)0.45f, Math.sin(f3) * 0.25);
        if (var3 != null) {
            this.field_70170_p.func_72838_d((Entity)var3);
        }
        return is;
    }

    protected void func_70628_a(boolean par1, int par2) {
        this.dropBlockRand(Blocks.field_150368_y, 1);
        int i = 12 + this.field_70170_p.field_73012_v.nextInt(7);
        for (int var4 = 0; var4 < i; ++var4) {
            this.dropItemRand(Items.field_151055_y, 1);
            this.dropItemRand(Basic.apples, 1);
            this.dropItemRand(Basic.balloons, 1);
            this.dropBlockRand(Blocks.field_150368_y, 2);
            this.dropItemRand(Items.field_151042_j, 1);
            int var3 = this.field_70170_p.field_73012_v.nextInt(10);
            if (var3 == 0) {
                this.dropItemRand(Items.field_151055_y, 1);
            }
            if (var3 == 1) {
                this.dropItemRand(Basic.apples, 1);
            }
            if (var3 == 2) {
                this.dropItemRand(Basic.balloons, 1);
            }
            if (var3 != 3) continue;
            this.dropItemRand(Items.field_151042_j, 1);
        }
    }

    public void func_70609_aI() {
        super.func_70609_aI();
        for (int i = 0; i < 40; ++i) {
            float var1 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float var2 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float var3 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)var1, this.field_70163_u + 2.0 + (double)var2, this.field_70161_v + (double)var3, 0.0, 0.75, 0.0);
            this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)var1, this.field_70163_u + 2.0 + (double)var2, this.field_70161_v + (double)var3, 0.0, 0.75, 0.0);
            this.field_70170_p.func_72869_a("bubble", this.field_70165_t + (double)var1, this.field_70163_u + 2.0 + (double)var2, this.field_70161_v + (double)var3, 0.0, 0.75, 0.0);
        }
    }

    public boolean func_70601_bi() {
        for (int k = -3; k < 3; ++k) {
            for (int j = -3; j < 3; ++j) {
                for (int i = 0; i < 5; ++i) {
                    Block bid = this.field_70170_p.func_147439_a((int)this.field_70165_t + j, (int)this.field_70163_u + i, (int)this.field_70161_v + k);
                    if (bid != Blocks.field_150474_ac) continue;
                    TileEntityMobSpawner tileentitymobspawner = null;
                    tileentitymobspawner = (TileEntityMobSpawner)this.field_70170_p.func_147438_o((int)this.field_70165_t + j, (int)this.field_70163_u + i, (int)this.field_70161_v + k);
                    String s = tileentitymobspawner.func_145881_a().func_98276_e();
                    if (s == null || !s.equals("MyLeviathan")) continue;
                    return true;
                }
            }
        }
        if (!this.func_70814_o()) {
            return false;
        }
        if (this.field_70170_p.func_72935_r()) {
            return false;
        }
        MyLeviathan target = null;
        target = (MyLeviathan)this.field_70170_p.func_72857_a(MyLeviathan.class, this.field_70121_D.func_72314_b(64.0, 32.0, 64.0), (Entity)this);
        return target == null;
    }

    protected Item getDropItemId() {
        return Basic.apples;
    }

    @SideOnly(value=Side.CLIENT)
    public static class RenderTheMob3
    extends RenderLiving {
        private static final ResourceLocation dleviathantexture = new ResourceLocation("kingbowsermod", "textures/mobs/leviathan.png");

        public RenderTheMob3(ModelBase par1ModelBase, float par2) {
            super(par1ModelBase, par2);
        }

        protected ResourceLocation func_110775_a(Entity entity) {
            return dleviathantexture;
        }
    }
}

