/*
 * Decompiled with CFR 0.152.
 */
package twilightsparkle.basic.mob;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightsparkle.basic.Basic;
import twilightsparkle.basic.mob.AIFollowOwner;
import twilightsparkle.basic.mob.EntityAIWander;
import twilightsparkle.basic.mob.GenericTargetSorter;
import twilightsparkle.basic.mob.MobUtils;
import twilightsparkle.basic.mob.MovementInputProxy;
import twilightsparkle.basic.mob.MyAJ;
import twilightsparkle.basic.mob.MyDashCloud;
import twilightsparkle.basic.mob.MyLeviathan;
import twilightsparkle.basic.mob.MyPhoenix;
import twilightsparkle.basic.mob.MyTwilicorn;
import twilightsparkle.basic.mob.MyTwilightMagic;
import twilightsparkle.basic.mob.RainbowCannon;
import twilightsparkle.basic.mob.RenderInfo;

public class MyDash
extends EntityTameable {
    private int boatPosRotationIncrements;
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
    private double boatYawHead;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private int stream_count = 0;
    private GenericTargetSorter TargetSorter = null;
    private RenderInfo renderdata = new RenderInfo();
    private int dmgDelay = 0;
    private int wing_sound = 0;
    private ChunkCoordinates currentFlightTarget = null;
    private boolean target_in_sight = false;
    private int owner_flying = 0;
    private int flyaway = 0;
    private int stuck_count = 0;
    private int lastX = 0;
    private int lastZ = 0;
    private int gothitcount = 0;
    private int gothitcountmob = 0;
    private int unstick_timer = 0;
    private float moveSpeed = 4.95f;
    private float deltasmooth = 0.0f;
    protected MovementInputProxy riderInput;

    public MyDash(World par1World) {
        super(par1World);
        this.func_70105_a(0.75f, 1.0f);
        this.func_70661_as().func_75491_a(true);
        this.field_70728_aV = 2000;
        this.field_70174_ab = 10;
        this.field_70178_ae = true;
        this.field_70155_l = 12.0;
        this.func_70904_g(false);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIFollowOwner(this, 1.1f, 16.0f, 2.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Basic.lightningCloud, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 16, 0.75));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 9.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        if (Basic.Snap == 0) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, true, false, IMob.field_82192_a));
        }
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70153_n = null;
        this.TargetSorter = new GenericTargetSorter((Entity)this);
        this.renderdata = new RenderInfo();
    }

    public MyDash(World par1World, double par2, double par4, double par6) {
        this(par1World);
        this.func_70107_b(par2, par4 + (double)this.field_70129_M, par6);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = par2;
        this.field_70167_r = par4;
        this.field_70166_s = par6;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.mygetMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.moveSpeed);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(275.0);
    }

    public int getTrackingRange() {
        return 128;
    }

    public int getUpdateFrequency() {
        return 10;
    }

    public boolean sendsVelocityUpdates() {
        return true;
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    protected boolean func_70041_e_() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.setActivity(0);
        this.setAttacking(0);
        this.setBeingRidden(0);
        this.func_70903_f(false);
        if (this.renderdata == null) {
            this.renderdata = new RenderInfo();
        }
        this.renderdata.rf1 = 0.0f;
        this.renderdata.rf2 = 0.0f;
        this.renderdata.rf3 = 0.0f;
        this.renderdata.rf4 = 0.0f;
        this.renderdata.ri1 = 0;
        this.renderdata.ri2 = 0;
        this.renderdata.ri3 = 0;
        this.renderdata.ri4 = 0;
    }

    public int mygetMaxHealth() {
        return 1200;
    }

    public int getRainbowHealth() {
        return (int)this.func_110143_aJ();
    }

    public RenderInfo getRenderInfo() {
        return this.renderdata;
    }

    public void setRenderInfo(RenderInfo r) {
        this.renderdata.rf1 = r.rf1;
        this.renderdata.rf2 = r.rf2;
        this.renderdata.rf3 = r.rf3;
        this.renderdata.rf4 = r.rf4;
        this.renderdata.ri1 = r.ri1;
        this.renderdata.ri2 = r.ri2;
        this.renderdata.ri3 = r.ri3;
        this.renderdata.ri4 = r.ri4;
    }

    public int func_70658_aO() {
        return 21;
    }

    protected void func_70664_aZ() {
        super.func_70664_aZ();
        this.field_70181_x += 0.25;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70648_aU() {
        return false;
    }

    public String func_70639_aQ() {
        if (Basic.PonyVoices != 0) {
            return "kingbowsermod:dash_a";
        }
        return "";
    }

    protected String func_70621_aR() {
        return "damage.hit";
    }

    protected String func_70673_aS() {
        return "kingbowsermod:rainboom";
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return 0.75;
    }

    protected ItemFood getDropItemId() {
        return Basic.dashMeat;
    }

    private ItemStack dropItemRand(Item index, int par1) {
        EntityItem var3 = null;
        ItemStack is = new ItemStack(index, par1, 0);
        var3 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), this.field_70163_u + 1.0, this.field_70161_v + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), is);
        float f3 = (float)Math.atan2((double)Basic.TwilightRand2.nextInt() - this.field_70161_v, (double)Basic.TwilightRand2.nextInt() - this.field_70165_t);
        var3.func_70024_g(Math.cos(f3) * 0.25, (double)0.45f, Math.sin(f3) * 0.25);
        if (var3 != null) {
            this.field_70170_p.func_72838_d((Entity)var3);
        }
        return is;
    }

    private ItemStack dropBlockRand(Block index, int par1) {
        EntityItem var3 = null;
        ItemStack is = new ItemStack(index, par1, 0);
        var3 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), this.field_70163_u + 1.0, this.field_70161_v + (double)Basic.TwilightRand.nextInt(3) - (double)Basic.TwilightRand.nextInt(3), is);
        float f3 = (float)Math.atan2((double)Basic.TwilightRand2.nextInt() - this.field_70161_v, (double)Basic.TwilightRand2.nextInt() - this.field_70165_t);
        var3.func_70024_g(Math.cos(f3) * 0.25, (double)0.45f, Math.sin(f3) * 0.25);
        if (var3 != null) {
            this.field_70170_p.func_72838_d((Entity)var3);
        }
        return is;
    }

    protected void func_70628_a(boolean par1, int par2) {
        int var4;
        int i = 4 + this.field_70170_p.field_73012_v.nextInt(6);
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand(Items.field_151008_G, 1);
        }
        i = 16 + this.field_70170_p.field_73012_v.nextInt(6);
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.dashMeat, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.dashMeat, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.dashMeat, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.dashMeat, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.dashMeat, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.dashMeat, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.dashMeat, 1);
        }
        i = 2 + this.field_70170_p.field_73012_v.nextInt(6);
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand(Basic.lightningCloud, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand(Basic.lightningCloud, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand(Basic.lightningCloud, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand(Basic.lightningCloud, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand(Basic.lightningCloud, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand(Basic.lightningCloud, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand(Basic.lightningCloud, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand(Basic.lightningCloud, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.rainbow, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.rainbow, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.rainbow, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.rainbow, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.rainbow, 1);
        }
        for (var4 = 0; var4 < i; ++var4) {
            this.dropItemRand((Item)Basic.rainbow, 1);
        }
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (par1Entity != null && par1Entity instanceof EntityLivingBase) {
            float s = par1Entity.field_70131_O * par1Entity.field_70130_N;
            if (this.func_110143_aJ() < 150.0f) {
                EntityLivingBase e = (EntityLivingBase)par1Entity;
                e.func_70691_i(-200.0f);
                this.doRainboomDamage(this.field_70165_t, this.field_70163_u, this.field_70161_v, 16.0, 375.0, 1);
            }
        }
        double ks = 4.5;
        double inair = 0.55;
        float iskraken = 1.0f;
        if (par1Entity != null && par1Entity instanceof EntityDragon) {
            EntityDragon dr = (EntityDragon)par1Entity;
            DamageSource var21 = null;
            var21 = DamageSource.func_94539_a(null);
            var21.func_94540_d();
            if (this.field_70170_p.field_73012_v.nextInt(1) == 1) {
                dr.func_70965_a(dr.field_70986_h, var21, 225.0f);
            } else {
                dr.func_70965_a(dr.field_70987_i, var21, 225.0f);
            }
        } else if (par1Entity != null && par1Entity instanceof EntityLivingBase) {
            if (par1Entity instanceof MyLeviathan) {
                iskraken = 4.0f;
            }
            par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), iskraken * 555.0f);
            float f3 = (float)Math.atan2(par1Entity.field_70161_v - this.field_70161_v, par1Entity.field_70165_t - this.field_70165_t);
            if (par1Entity.field_70128_L || par1Entity instanceof EntityPlayer) {
                inair *= 2.0;
            }
            par1Entity.func_70024_g(Math.cos(f3) * ks, inair, Math.sin(f3) * ks);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean ret = false;
        Entity e = par1DamageSource.func_76346_g();
        if (this.dmgDelay > 0) {
            return false;
        }
        float dm = par2;
        if (dm > 1750.0f) {
            dm = 1750.0f;
        }
        if (e != null && e instanceof EntityPlayer) {
            ++this.gothitcount;
        }
        if (e != null) {
            ++this.gothitcountmob;
        }
        if (par1DamageSource.func_76355_l().equals("inWall")) {
            return ret;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70904_g(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setActivity(1);
        }
        if ((e = par1DamageSource.func_76346_g()) != null && e instanceof MyPhoenix) {
            return false;
        }
        ret = super.func_70097_a(par1DamageSource, dm);
        this.dmgDelay = 8;
        if (e != null && e instanceof EntityLivingBase && !this.field_70170_p.field_72995_K) {
            if (this.func_70909_n() && e instanceof EntityPlayer) {
                return false;
            }
            this.func_70624_b((EntityLivingBase)e);
            this.func_70784_b(e);
            this.func_70661_as().func_75497_a((Entity)((EntityLivingBase)e), 1.8);
            ret = true;
        }
        return ret;
    }

    public void func_70619_bc() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        super.func_70619_bc();
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_73012_v.nextInt(200) == 1) {
            this.func_70624_b(null);
        }
    }

    protected void func_70629_bd() {
        if (this.field_70153_n != null) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        super.func_70629_bd();
    }

    private boolean isSuitableTarget(EntityLivingBase par1EntityLiving, boolean par2) {
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (par1EntityLiving == null) {
            return false;
        }
        if (par1EntityLiving == this) {
            return false;
        }
        if (!par1EntityLiving.func_70089_S()) {
            return false;
        }
        if (!this.func_70635_at().func_75522_a((Entity)par1EntityLiving)) {
            return false;
        }
        if (par1EntityLiving instanceof MyAJ) {
            return false;
        }
        if (par1EntityLiving instanceof EntityMob) {
            return !(par1EntityLiving instanceof MyTwilightMagic);
        }
        if (par1EntityLiving instanceof MyDash) {
            return false;
        }
        if (par1EntityLiving instanceof MyTwilightMagic) {
            return false;
        }
        if (par1EntityLiving instanceof MyTwilicorn) {
            return false;
        }
        if (par1EntityLiving instanceof MyDashCloud) {
            return false;
        }
        if (par1EntityLiving instanceof EntityAnimal) {
            return false;
        }
        if (par1EntityLiving instanceof EntityVillager) {
            return false;
        }
        if (this.func_70909_n()) {
            return false;
        }
        return MobUtils.isAttackableNonMob(par1EntityLiving);
    }

    private EntityLivingBase findSomethingToAttack() {
        if (Basic.Snap != 0) {
            return null;
        }
        List var5 = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(96.0, 48.0, 96.0));
        Collections.sort(var5, this.TargetSorter);
        Iterator var2 = var5.iterator();
        Entity var3 = null;
        EntityLivingBase var4 = null;
        EntityLivingBase e = this.func_70638_az();
        if (e != null && e.func_70089_S()) {
            return e;
        }
        while (var2.hasNext()) {
            var3 = (Entity)var2.next();
            var4 = (EntityLivingBase)var3;
            if (!this.isSuitableTarget(var4, false)) continue;
            return var4;
        }
        return null;
    }

    public boolean func_145773_az() {
        return false;
    }

    public boolean func_70601_bi() {
        for (int k = -3; k < 3; ++k) {
            for (int j = -3; j < 3; ++j) {
                for (int i = 0; i < 5; ++i) {
                    Block bid = this.field_70170_p.func_147439_a((int)this.field_70165_t + j, (int)this.field_70163_u + i, (int)this.field_70161_v + k);
                    if (bid != Blocks.field_150474_ac) continue;
                    TileEntityMobSpawner tileentitymobspawner = null;
                    tileentitymobspawner = (TileEntityMobSpawner)this.field_70170_p.func_147438_o((int)this.field_70165_t + j, (int)this.field_70163_u + i, (int)this.field_70161_v + k);
                    String s = tileentitymobspawner.func_145881_a().func_98276_e();
                    if (s == null || !s.equals("MyDash")) continue;
                    return true;
                }
            }
        }
        if (this.field_70170_p.field_73012_v.nextInt(16) != 0) {
            return false;
        }
        MyDash target = null;
        if (!this.field_70170_p.func_72935_r()) {
            return false;
        }
        target = (MyDash)this.field_70170_p.func_72857_a(MyDash.class, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0), (Entity)this);
        if (target != null) {
            return false;
        }
        return !(this.field_70163_u < 50.0);
    }

    public boolean canSeeTarget(double pX, double pY, double pZ) {
        return this.field_70170_p.func_72901_a(Vec3.func_72443_a((double)this.field_70165_t, (double)(this.field_70163_u + 1.25), (double)this.field_70161_v), Vec3.func_72443_a((double)pX, (double)pY, (double)pZ), false) == null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        super.func_70056_a(par1, par3, par5, par7, par8, par9);
        this.boatPosRotationIncrements = par9;
        this.boatX = par1;
        this.boatY = par3;
        this.boatZ = par5;
        this.boatYaw = par7;
        this.boatPitch = par8;
        this.boatYawHead = par7;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        super.func_70016_h(par1, par3, par5);
    }

    public void func_70071_h_() {
        EntityLivingBase e = null;
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.moveSpeed);
        super.func_70071_h_();
        if (this.dmgDelay > 0) {
            --this.dmgDelay;
        }
        if (this.getActivity() == 1) {
            ++this.wing_sound;
            if (this.wing_sound > 20) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72956_a((Entity)this, "kingbowsermod:flap_a", 0.8f, 1.0f);
                }
                this.wing_sound = 0;
            }
        }
        if (this.func_70090_H()) {
            this.field_70181_x += 0.07;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getActivity() == 0 && this.func_70909_n() && this.func_70902_q() != null && !this.func_70906_o() && (e = this.func_70902_q()) != null && this.func_70068_e((Entity)e) > 144.0) {
            this.setActivity(1);
        }
    }

    private void Dash() {
        int xdir = 1;
        int zdir = 1;
        int keep_trying = 50;
        boolean do_new = false;
        double ox = 0.0;
        double oy = 0.0;
        double oz = 0.0;
        this.field_70145_X = false;
        boolean has_owner = false;
        EntityLivingBase e = null;
        double speed_factor = 0.5;
        double var1 = 0.0;
        double var3 = 0.0;
        double var5 = 0.0;
        double gh = 1.25;
        double obstruction_factor = 0.0;
        double velocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        boolean toofar = false;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.currentFlightTarget == null) {
            do_new = true;
            this.currentFlightTarget = new ChunkCoordinates((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
        if (this.func_70906_o()) {
            return;
        }
        if (this.field_70153_n != null) {
            return;
        }
        if (this.unstick_timer > 0) {
            --this.unstick_timer;
        }
        if (this.lastX == (int)this.field_70165_t && this.lastZ == (int)this.field_70161_v) {
            ++this.stuck_count;
            if (this.stuck_count > 10) {
                this.stuck_count = 0;
                this.unstick_timer = 100;
                this.target_in_sight = false;
                this.setAttacking(0);
                this.setActivity(1);
                do_new = true;
            }
        } else {
            this.stuck_count = 0;
            this.lastX = (int)this.field_70165_t;
            this.lastZ = (int)this.field_70161_v;
        }
        this.field_70181_x = this.field_70163_u < (double)this.currentFlightTarget.field_71572_b + 2.0 ? (this.field_70181_x *= 0.7) : (this.field_70163_u > (double)this.currentFlightTarget.field_71572_b - 2.0 ? (this.field_70181_x *= 0.5) : (this.field_70181_x *= 0.61));
        if (this.field_70170_p.field_73012_v.nextInt(60) == 1) {
            do_new = true;
        }
        this.doRainboomDamage(this.field_70165_t, this.field_70163_u, this.field_70161_v, 16.0, 275.0, 1);
        if (this.func_70909_n() && this.func_70902_q() != null) {
            e = this.func_70902_q();
            has_owner = true;
            ox = e.field_70165_t;
            oy = e.field_70163_u;
            oz = e.field_70161_v;
            if (this.func_70068_e((Entity)e) > 144.0) {
                toofar = true;
                this.target_in_sight = false;
                this.setAttacking(0);
                this.flyaway = 0;
                do_new = true;
            }
        }
        if (this.flyaway > 0) {
            --this.flyaway;
        }
        if (!toofar && this.unstick_timer == 0 && this.flyaway == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            e = this.findSomethingToAttack();
            if (e != null) {
                this.field_70145_X = true;
                if (this.func_70909_n() && this.func_110143_aJ() / (float)this.mygetMaxHealth() < 0.25f) {
                    this.setActivity(1);
                    this.setAttacking(1);
                    this.RainbowAtk(e);
                    this.target_in_sight = false;
                    do_new = false;
                    this.currentFlightTarget.func_71571_b((int)(this.field_70165_t + (this.field_70165_t - e.field_70165_t)), (int)(this.field_70163_u + 1.0), (int)(this.field_70161_v + (this.field_70161_v - e.field_70161_v)));
                } else {
                    this.setActivity(1);
                    this.setAttacking(1);
                    this.RainbowAtk(e);
                    this.target_in_sight = true;
                    this.currentFlightTarget.func_71571_b((int)e.field_70165_t, (int)(e.field_70163_u + 1.0), (int)e.field_70161_v);
                    do_new = false;
                    if (this.func_70068_e((Entity)e) < (double)((16.0f + e.field_70130_N / 2.0f) * (16.0f + e.field_70130_N / 2.0f))) {
                        this.func_70652_k((Entity)e);
                    }
                    if (this.func_110143_aJ() < 75.0f) {
                        this.setActivity(0);
                        this.setAttacking(0);
                        do_new = true;
                        this.flyaway = 1;
                        this.currentFlightTarget = new ChunkCoordinates((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
                    }
                    if (this.field_70170_p.field_73012_v.nextInt(600) == 1) {
                        e = null;
                        do_new = true;
                        this.setAttacking(0);
                    }
                }
            } else {
                this.field_70145_X = false;
                this.target_in_sight = false;
                this.flyaway = 0;
                this.setAttacking(0);
            }
        }
        if (do_new && !this.target_in_sight || do_new && this.flyaway != 0) {
            Block bid = Blocks.field_150348_b;
            while (bid != Blocks.field_150350_a && keep_trying != 0) {
                int gox = (int)this.field_70165_t;
                int goy = (int)this.field_70163_u;
                int goz = (int)this.field_70161_v;
                if (has_owner && this.unstick_timer == 0) {
                    gox = (int)ox;
                    goy = (int)oy;
                    goz = (int)oz;
                    if (this.owner_flying == 0) {
                        zdir = this.field_70170_p.field_73012_v.nextInt(18) + 6;
                        xdir = this.field_70170_p.field_73012_v.nextInt(18) + 6;
                    } else {
                        zdir = this.field_70170_p.field_73012_v.nextInt(16);
                        xdir = this.field_70170_p.field_73012_v.nextInt(16);
                    }
                } else {
                    zdir = this.field_70170_p.field_73012_v.nextInt(20) + 6;
                    xdir = this.field_70170_p.field_73012_v.nextInt(20) + 6;
                }
                if (this.field_70170_p.field_73012_v.nextInt(2) == 1) {
                    zdir = -zdir;
                }
                if (this.field_70170_p.field_73012_v.nextInt(2) == 1) {
                    xdir = -xdir;
                }
                this.currentFlightTarget.func_71571_b(gox + xdir, goy + this.field_70170_p.field_73012_v.nextInt(12 + this.owner_flying * 2) - 4, goz + zdir);
                bid = this.field_70170_p.func_147439_a(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c);
                if (bid == Blocks.field_150350_a && !this.canSeeTarget(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c)) {
                    bid = Blocks.field_150348_b;
                }
                --keep_trying;
            }
        }
        obstruction_factor = 0.0;
        int dist = 2;
        dist += (int)(velocity * 4.0);
        for (int k = 1; k < dist; ++k) {
            for (int i = 1; i < dist * 2; ++i) {
                double dz;
                double dx = (double)i * Math.cos(Math.toRadians(this.field_70177_z + 90.0f));
                Block bid = this.field_70170_p.func_147439_a((int)(this.field_70165_t + dx), (int)this.field_70163_u - k, (int)(this.field_70161_v + (dz = (double)i * Math.sin(Math.toRadians(this.field_70177_z + 90.0f)))));
                if (bid == Blocks.field_150350_a) continue;
                obstruction_factor += 0.05;
            }
        }
        this.field_70181_x += obstruction_factor * 0.05;
        this.field_70163_u += obstruction_factor * 0.05;
        speed_factor = 1.5;
        var1 = (double)this.currentFlightTarget.field_71574_a + 0.5 - this.field_70165_t;
        var3 = (double)this.currentFlightTarget.field_71572_b + 0.5 - this.field_70163_u;
        var5 = (double)this.currentFlightTarget.field_71573_c + 0.5 - this.field_70161_v;
        if (this.owner_flying != 0) {
            speed_factor = 2.25;
            if (this.func_70909_n() && this.func_70902_q() != null && this.func_70068_e((Entity)(e = this.func_70902_q())) > 49.0) {
                speed_factor = 2.5;
            }
        }
        this.field_70159_w += (Math.signum(var1) - this.field_70159_w) * 0.25 * speed_factor;
        this.field_70181_x += (Math.signum(var3) - this.field_70181_x) * 0.2 * speed_factor;
        this.field_70179_y += (Math.signum(var5) - this.field_70179_y) * 0.25 * speed_factor;
        float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
        float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
        this.field_70701_bs = (float)(0.75 * speed_factor);
        this.field_70177_z += var8 / 1.0f;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public void func_70636_d() {
        List list = null;
        Entity listEntity = null;
        double d6 = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
        double d7 = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
        double obstruction_factor = 0.0;
        double relative_g = 0.0;
        double max_speed = 1.15;
        double gh = 1.0;
        double rt = 0.0;
        double pi = 3.1415926545;
        double deltav = 0.0;
        int dist = 2;
        this.FlyAway();
        if (this.getActivity() == 0) {
            super.func_70636_d();
        } else if (this.field_70128_L) {
            super.func_70636_d();
            return;
        }
        if (this.field_70128_L) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.boatPosRotationIncrements > 0 && this.getActivity() != 0) {
                double d4 = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
                double d5 = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
                double d11 = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
                this.func_70107_b(d4, d5, d11);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
                double d10 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
                if (this.field_70153_n != null) {
                    d10 = MathHelper.func_76138_g((double)(this.field_70153_n.field_70177_z - this.field_70177_z));
                }
                this.field_70177_z = (float)((double)this.field_70177_z + d10 / (double)this.boatPosRotationIncrements);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70177_z;
                --this.boatPosRotationIncrements;
            }
        } else {
            if (this.field_70153_n != null) {
                this.setBeingRidden(1);
            } else {
                this.setBeingRidden(0);
            }
            if (this.getActivity() != 0) {
                if (this.field_70153_n != null) {
                    if (this.field_70159_w < -2.0) {
                        this.field_70159_w = -2.0;
                    }
                    if (this.field_70159_w > 2.0) {
                        this.field_70159_w = 2.0;
                    }
                    if (this.field_70179_y < -2.0) {
                        this.field_70179_y = -2.0;
                    }
                    if (this.field_70179_y > 2.0) {
                        this.field_70179_y = 2.0;
                    }
                    double velocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                    gh = 1.55;
                    Block bid = this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)((float)this.field_70163_u - (float)gh), (int)this.field_70161_v);
                    if (bid != Blocks.field_150350_a) {
                        this.field_70181_x += 0.03;
                        this.field_70163_u += 0.1;
                    } else {
                        this.field_70181_x -= 0.018;
                    }
                    obstruction_factor = 0.0;
                    dist = 3;
                    dist += (int)(velocity * 7.0);
                    for (int k = 1; k < dist; ++k) {
                        for (int i = 1; i < dist * 2; ++i) {
                            double dz;
                            double dx = (double)i * Math.cos(Math.toRadians(this.field_70177_z + 90.0f));
                            bid = this.field_70170_p.func_147439_a((int)(this.field_70165_t + dx), (int)this.field_70163_u - k, (int)(this.field_70161_v + (dz = (double)i * Math.sin(Math.toRadians(this.field_70177_z + 90.0f)))));
                            if (bid == Blocks.field_150350_a) continue;
                            obstruction_factor += 0.05;
                        }
                    }
                    this.field_70181_x += obstruction_factor * 0.07;
                    this.field_70163_u += obstruction_factor * 0.07;
                    if (this.field_70181_x > 2.0) {
                        this.field_70181_x = 2.0;
                    }
                    if (this.field_70153_n != null) {
                        double d4 = this.field_70153_n.field_70177_z;
                        d4 %= 360.0;
                        while (d4 < 0.0) {
                            d4 += 360.0;
                        }
                        double d5 = this.field_70177_z;
                        d5 %= 360.0;
                        while (d5 < 0.0) {
                            d5 += 360.0;
                        }
                        for (relative_g = (d4 - d5) % 180.0; relative_g < 0.0; relative_g += 180.0) {
                        }
                        if (relative_g > 90.0) {
                            relative_g -= 180.0;
                        }
                        if (velocity > 0.01) {
                            d4 = 1.85 - velocity;
                            if ((d4 = Math.abs(d4)) < 0.01) {
                                d4 = 0.01;
                            }
                            if (d4 > 0.9) {
                                d4 = 0.9;
                            }
                            this.field_70177_z = this.field_70153_n.field_70177_z + (float)(relative_g * d4);
                        } else {
                            this.field_70177_z = this.field_70153_n.field_70177_z;
                        }
                        relative_g = Math.abs(relative_g) * velocity;
                        if (relative_g > 50.0) {
                            relative_g = 0.0;
                        }
                    }
                    this.field_70125_A = 2.0f * (float)velocity;
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                    this.field_70759_as = this.field_70177_z;
                    double newvelocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                    if (this.riderInput != null) {
                        double rdv;
                        double rr = Math.atan2(this.field_70153_n.field_70179_y, this.field_70153_n.field_70159_w);
                        double rhm = Math.atan2(this.field_70179_y, this.field_70159_w);
                        double rhdir = Math.toRadians((this.field_70153_n.field_70177_z + 90.0f) % 360.0f);
                        rt = 0.0;
                        pi = 3.1415926545;
                        deltav = 0.0;
                        float im = this.riderInput.moveForward;
                        if (this.riderInput.jump) {
                            this.field_70181_x += 0.025;
                            this.field_70181_x += velocity * 0.028;
                        }
                        if ((rdv = Math.abs(rhm - rhdir) % (pi * 2.0)) > pi) {
                            rdv -= pi * 2.0;
                        }
                        rdv = Math.abs(rdv);
                        if (Math.abs(newvelocity) < 0.01) {
                            rdv = 0.0;
                        }
                        if (rdv > 1.5) {
                            newvelocity = -newvelocity;
                        }
                        if (Math.abs(im) > 0.001f) {
                            if (im > 0.0f) {
                                deltav = 0.018;
                                if (max_speed > 1.0) {
                                    deltav += 0.05;
                                }
                                if (this.deltasmooth < 0.0f) {
                                    this.deltasmooth = 0.0f;
                                }
                                this.deltasmooth = (float)((double)this.deltasmooth + deltav / 10.0);
                                if ((double)this.deltasmooth > deltav) {
                                    this.deltasmooth = (float)deltav;
                                }
                            } else {
                                max_speed = 0.35;
                                deltav = -0.02;
                                if (this.deltasmooth > 0.0f) {
                                    this.deltasmooth = 0.0f;
                                }
                                this.deltasmooth = (float)((double)this.deltasmooth + deltav / 10.0);
                                if ((double)this.deltasmooth < deltav) {
                                    this.deltasmooth = (float)deltav;
                                }
                            }
                            if ((newvelocity += (double)this.deltasmooth) >= 0.0) {
                                if (newvelocity > max_speed) {
                                    newvelocity = max_speed;
                                }
                                this.field_70159_w = Math.cos(Math.toRadians(this.field_70177_z + 90.0f)) * newvelocity;
                                this.field_70179_y = Math.sin(Math.toRadians(this.field_70177_z + 90.0f)) * newvelocity;
                            } else {
                                if (newvelocity < -max_speed) {
                                    newvelocity = -max_speed;
                                }
                                newvelocity = -newvelocity;
                                this.field_70159_w = Math.cos(Math.toRadians(this.field_70177_z + 270.0f)) * newvelocity;
                                this.field_70179_y = Math.sin(Math.toRadians(this.field_70177_z + 270.0f)) * newvelocity;
                            }
                        } else if (newvelocity >= 0.0) {
                            this.field_70159_w = Math.cos(Math.toRadians(this.field_70177_z + 90.0f)) * newvelocity;
                            this.field_70179_y = Math.sin(Math.toRadians(this.field_70177_z + 90.0f)) * newvelocity;
                        } else {
                            this.field_70159_w = Math.cos(Math.toRadians(this.field_70177_z + 270.0f)) * (newvelocity * -1.0);
                            this.field_70179_y = Math.sin(Math.toRadians(this.field_70177_z + 270.0f)) * (newvelocity * -1.0);
                        }
                    }
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70159_w *= 0.985;
                    this.field_70181_x *= 0.94;
                    this.field_70179_y *= 0.985;
                    if (!this.field_70170_p.field_72995_K && (list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.5, 0.5, 0.5))) != null && !list.isEmpty()) {
                        for (int l = 0; l < list.size(); ++l) {
                            listEntity = (Entity)list.get(l);
                            if (listEntity == this.field_70153_n || listEntity.field_70128_L || !listEntity.func_70104_M()) continue;
                            listEntity.func_70108_f((Entity)this);
                        }
                    }
                    if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                        this.field_70153_n = null;
                    }
                } else {
                    this.Dash();
                }
            }
        }
    }

    public void FlyAway() {
        EntityLivingBase e = null;
        EntityPlayer pl = null;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.func_70906_o() && this.getActivity() == 0 && this.field_70153_n == null && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.field_70170_p.field_73012_v.nextInt(10) == 1 && (e = this.findSomethingToAttack()) != null) {
            this.setActivity(1);
        }
        if (this.field_70170_p.field_73012_v.nextInt(360) == 1 && this.func_110143_aJ() < (float)this.mygetMaxHealth()) {
            this.func_70691_i(50.0f);
        }
        if (this.field_70170_p.field_73012_v.nextInt(180) == 1 && this.func_110143_aJ() < 300.0f) {
            this.func_70691_i(75.0f);
        }
        if (this.field_70170_p.field_73012_v.nextInt(90) == 1 && this.func_110143_aJ() < 300.0f) {
            this.func_70691_i(75.0f);
        }
        if (this.field_70170_p.field_73012_v.nextInt(45) == 1 && this.func_110143_aJ() < 150.0f) {
            this.func_70691_i(75.0f);
        }
        if (this.func_70906_o()) {
            return;
        }
        this.owner_flying = 0;
        if (this.func_70909_n() && this.func_70902_q() != null && this.field_70153_n == null && !this.func_70906_o()) {
            pl = (EntityPlayer)this.func_70902_q();
            if (pl.field_71075_bZ.field_75100_b) {
                this.owner_flying = 1;
                this.setActivity(1);
            }
        }
        if (this.func_70909_n() && this.func_70902_q() != null && !this.func_70906_o() && this.func_70068_e((Entity)(pl = (EntityPlayer)this.func_70902_q())) > 400.0) {
            this.setActivity(1);
        }
        if (this.field_70170_p.field_73012_v.nextInt(50) == 1 && !this.func_70906_o() && !this.target_in_sight && this.field_70153_n == null) {
            if (this.field_70170_p.field_73012_v.nextInt(15) == 1) {
                this.setActivity(1);
            } else {
                this.setActivity(1);
            }
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            float f = 0.65f;
            this.field_70153_n.func_70107_b(this.field_70165_t - (double)f * Math.sin(Math.toRadians(this.field_70177_z)), this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + (double)f * Math.cos(Math.toRadians(this.field_70177_z)));
        }
    }

    protected void func_70908_e(boolean par1) {
        String s = "heart";
        if (!par1) {
            s = "smoke";
        }
        for (int i = 0; i < 60; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.08;
            double d1 = this.field_70146_Z.nextGaussian() * 0.08;
            double d2 = this.field_70146_Z.nextGaussian() * 0.08;
            this.field_70170_p.func_72869_a(s, this.field_70165_t + (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 2.5f), this.field_70163_u + 0.5 + (double)this.field_70146_Z.nextFloat() * 1.5, this.field_70161_v + (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 2.5f), d0, d1, d2);
        }
    }

    public boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        ItemStack var2 = par1EntityPlayer.field_71071_by.func_70448_g();
        if (var2 != null && var2.field_77994_a <= 0) {
            par1EntityPlayer.field_71071_by.func_70299_a(par1EntityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
            var2 = null;
        }
        if (var2 != null && var2.func_77973_b() == Basic.lightningCloud && par1EntityPlayer.func_70068_e((Entity)this) < 49.0) {
            EntityPlayer p = this.field_70170_p.func_72890_a((Entity)this, 10.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70903_f(true);
                this.func_152115_b(p.func_110124_au().toString());
                this.func_70908_e(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                this.func_70691_i((float)this.mygetMaxHealth() - this.func_110143_aJ());
            }
            if (!par1EntityPlayer.field_71075_bZ.field_75098_d) {
                --var2.field_77994_a;
                if (var2.field_77994_a <= 0) {
                    par1EntityPlayer.field_71071_by.func_70299_a(par1EntityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
                }
            }
            return true;
        }
        if (!this.func_70909_n()) {
            if (var2 != null && var2.func_77973_b() == Basic.lightningCloud && par1EntityPlayer.func_70068_e((Entity)this) < 49.0) {
                EntityPlayer p = this.field_70170_p.func_72890_a((Entity)this, 10.0);
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70170_p.field_73012_v.nextInt(1) == 0) {
                        this.func_70903_f(true);
                        this.func_152115_b(p.func_110124_au().toString());
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        this.func_70691_i((float)this.mygetMaxHealth() - this.func_110143_aJ());
                    } else {
                        this.func_70908_e(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                if (!par1EntityPlayer.field_71075_bZ.field_75098_d) {
                    --var2.field_77994_a;
                    if (var2.field_77994_a <= 0) {
                        par1EntityPlayer.field_71071_by.func_70299_a(par1EntityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                }
                return true;
            }
        } else {
            return false;
        }
        if (var2 == null && par1EntityPlayer.func_70068_e((Entity)this) < 49.0) {
            if (!this.field_70170_p.field_72995_K) {
                par1EntityPlayer.func_70078_a((Entity)this);
                this.setActivity(1);
                this.func_70904_g(false);
            }
            return true;
        }
        if (var2 != null && var2.func_77973_b() == Basic.lightningCloud && par1EntityPlayer.func_70068_e((Entity)this) < 49.0) {
            if (this.field_70170_p.field_72995_K) {
                this.func_70908_e(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            }
            if ((float)this.mygetMaxHealth() > this.func_110143_aJ()) {
                this.func_70691_i((float)this.mygetMaxHealth() - this.func_110143_aJ());
            }
            if (!par1EntityPlayer.field_71075_bZ.field_75098_d) {
                --var2.field_77994_a;
                if (var2.field_77994_a <= 0) {
                    par1EntityPlayer.field_71071_by.func_70299_a(par1EntityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
                }
            }
            return true;
        }
        if (var2 != null && var2.func_77973_b() == Basic.bowserBone && par1EntityPlayer.func_70068_e((Entity)this) < 49.0) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70903_f(false);
                this.func_152115_b("");
                this.func_70908_e(false);
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            if (!par1EntityPlayer.field_71075_bZ.field_75098_d) {
                --var2.field_77994_a;
                if (var2.field_77994_a <= 0) {
                    par1EntityPlayer.field_71071_by.func_70299_a(par1EntityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
                }
            }
            return true;
        }
        if (this.func_70909_n() && var2 != null && var2.func_77973_b() == Items.field_151057_cb && par1EntityPlayer.func_70068_e((Entity)this) < 49.0) {
            this.func_94058_c(var2.func_82833_r());
            if (!par1EntityPlayer.field_71075_bZ.field_75098_d) {
                --var2.field_77994_a;
                if (var2.field_77994_a <= 0) {
                    par1EntityPlayer.field_71071_by.func_70299_a(par1EntityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
                }
            }
            return true;
        }
        if (var2 != null && par1EntityPlayer.func_70068_e((Entity)this) < 49.0 && this.field_70153_n == null) {
            if (!this.func_70906_o()) {
                this.func_70904_g(true);
                this.setActivity(0);
            } else {
                this.func_70904_g(false);
                this.setActivity(0);
            }
            return true;
        }
        return false;
    }

    public boolean isWheat(ItemStack par1ItemStack) {
        return par1ItemStack != null && par1ItemStack.func_77973_b() == Basic.dashMeat;
    }

    public int getAttacking() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setAttacking(int par1) {
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            return;
        }
        this.field_70180_af.func_75692_b(20, (Object)par1);
    }

    public int getActivity() {
        return this.field_70180_af.func_75679_c(21);
    }

    public void setActivity(int par1) {
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            return;
        }
        this.field_70180_af.func_75692_b(21, (Object)par1);
    }

    public int getBeingRidden() {
        return this.field_70180_af.func_75679_c(22);
    }

    public void setBeingRidden(int par1) {
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            return;
        }
        this.field_70180_af.func_75692_b(22, (Object)par1);
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }

    protected boolean func_70692_ba() {
        if (this.func_104002_bU()) {
            return false;
        }
        if (this.field_70153_n != null) {
            return false;
        }
        return !this.func_70909_n();
    }

    private EntityLivingBase doRainboomDamage(double X, double Y, double Z, double dist, double damage, int knock) {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(X - dist), (double)(Y - 10.0), (double)(Z - dist), (double)(X + dist), (double)(Y + 10.0), (double)(Z + dist));
        List var5 = this.field_70170_p.func_72872_a(EntityLivingBase.class, bb);
        Collections.sort(var5, this.TargetSorter);
        Iterator var2 = var5.iterator();
        Entity var3 = null;
        EntityLivingBase var4 = null;
        while (var2.hasNext()) {
            var3 = (Entity)var2.next();
            var4 = (EntityLivingBase)var3;
            if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL || var4 == null || var4 == this || !var4.func_70089_S() || var4 instanceof MyDash || var4 instanceof MyTwilicorn || var4 instanceof MyAJ || var4 instanceof MyDashCloud || var4 instanceof MyTwilightMagic || var4 instanceof EntityPig || var4 instanceof EntityTameable || var4 instanceof EntityPlayer) continue;
            DamageSource var21 = null;
            var21 = DamageSource.func_94539_a(null);
            var21.func_94540_d();
            var4.func_70097_a(var21, (float)damage / 1.0f);
            var4.func_70097_a(DamageSource.field_76379_h, (float)damage / 1.0f);
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextInt(16) == 1) {
                this.field_70170_p.func_72956_a((Entity)var4, "kingbowsermod:lightningdeath", 4.5f, 3.0f);
            }
            int mx = 60;
            this.field_70170_p.func_72869_a("fireworksSpark", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian());
            this.field_70170_p.func_72869_a("fireworksSpark", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian());
            this.field_70170_p.func_72869_a("fireworksSpark", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian());
            this.field_70170_p.func_72869_a("fireworksSpark", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian());
            this.field_70170_p.func_72869_a("fireworksSpark", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian());
            this.field_70170_p.func_72869_a("fireworksSpark", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian());
            this.field_70170_p.func_72869_a("fireworksSpark", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian());
            this.field_70170_p.func_72869_a("fireworksSpark", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian());
            double ks = 1.75;
            double inair = 0.45;
            float f3 = (float)Math.atan2(var4.field_70161_v - this.field_70161_v, var4.field_70165_t - this.field_70165_t);
            var4.func_70024_g(Math.cos(f3) * ks, inair, Math.sin(f3) * ks);
        }
        return null;
    }

    public static Entity spawnCreature(World par0World, String par1, double par2, double par4, double par6) {
        Entity var8 = null;
        var8 = EntityList.func_75620_a((String)par1, (World)par0World);
        if (var8 != null) {
            var8.func_70012_b(par2, par4, par6, par0World.field_73012_v.nextFloat() * 360.0f, 0.0f);
            par0World.func_72838_d(var8);
        }
        return var8;
    }

    private void RainbowAtk(EntityLivingBase e) {
        double yoff = 1.75;
        double xzoff = 1.5;
        if (this.stream_count > 0) {
            RainbowCannon var2;
            this.setAttacking(2);
            if (this.field_70146_Z.nextInt(15) == 1) {
                var2 = new RainbowCannon(this.field_70170_p, e.field_70165_t - this.field_70165_t, e.field_70163_u + 0.75 - (this.field_70163_u + yoff), e.field_70161_v - this.field_70161_v);
                var2.func_70012_b(this.field_70165_t - xzoff * Math.sin(Math.toRadians(this.field_70759_as)), this.field_70163_u + yoff, this.field_70161_v + xzoff * Math.cos(Math.toRadians(this.field_70759_as)), this.field_70177_z, this.field_70125_A);
                this.field_70170_p.func_72956_a((Entity)this, "random.bow", 0.75f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_72838_d((Entity)var2);
            }
            var2 = new RainbowCannon(this.field_70170_p, e.field_70165_t - this.field_70165_t, e.field_70163_u + 0.75 - (this.field_70163_u + yoff), e.field_70161_v - this.field_70161_v);
            var2.func_70012_b(this.field_70165_t - xzoff * Math.sin(Math.toRadians(this.field_70759_as)), this.field_70163_u + yoff, this.field_70161_v + xzoff * Math.cos(Math.toRadians(this.field_70177_z)), this.field_70759_as, this.field_70125_A);
            double var3 = e.field_70165_t - var2.field_70165_t;
            double var5 = e.field_70163_u + 0.25 - var2.field_70163_u;
            double var7 = e.field_70161_v - var2.field_70161_v;
            float var9 = MathHelper.func_76133_a((double)(var3 * var3 + var7 * var7)) * 0.2f;
            var2.func_70186_c(var3, var5 + (double)var9, var7, 5.4f, 10.0f);
            this.field_70170_p.func_72956_a((Entity)this, "random.bow", 0.75f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)var2);
            --this.stream_count;
        } else {
            this.setAttacking(0);
        }
        if (this.stream_count <= 0 && this.field_70146_Z.nextInt(4) == 1) {
            this.stream_count = 6;
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Attacking", this.getAttacking());
        par1NBTTagCompound.func_74768_a("Flying", this.getActivity());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setAttacking(par1NBTTagCompound.func_74762_e("Attacking"));
        this.setActivity(par1NBTTagCompound.func_74762_e("Flying"));
    }

    @SideOnly(value=Side.CLIENT)
    public static class RenderTheMob23
    extends RenderLiving {
        private static final ResourceLocation dashtexture = new ResourceLocation("kingbowsermod", "textures/mobs/dash.png");

        public RenderTheMob23(ModelBase par1ModelBase, float par2) {
            super(par1ModelBase, par2);
        }

        protected ResourceLocation func_110775_a(Entity entity) {
            return dashtexture;
        }
    }
}

