/*
 * Decompiled with CFR 0.152.
 */
package twilightsparkle.basic;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderItem
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        EntityLivingBase p;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            p = (EntityLivingBase)data[1];
            this.render(p, item, 0);
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            p = (EntityLivingBase)data[1];
            this.renderFirstPerson(p, item, 0);
        }
    }

    protected void renderFirstPerson(EntityLivingBase player, ItemStack itemstack, int par3) {
        this.render(player, itemstack, par3);
    }

    protected void render(EntityLivingBase player, ItemStack itemstack, int par3) {
        RenderItem.doRenderItem(player, itemstack, par3);
    }

    public static void doRenderItem(EntityLivingBase entity, ItemStack itemstack, int color) {
        RenderItem.doRenderItem(entity, itemstack, color, false);
    }

    public static void doRenderItem(EntityLivingBase entity, ItemStack itemstack, int color, boolean effect) {
        IIcon icon = entity.func_70620_b(itemstack, color);
        RenderItem.doRenderItem(icon, itemstack, color, effect);
    }

    public static void doRenderItem(IIcon icon, ItemStack itemstack, int effectColor, boolean effect) {
        if (icon == null) {
            GL11.glPopMatrix();
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ResourceLocation resourcelocation = mc.field_71446_o.func_130087_a(itemstack.func_94608_d());
        mc.field_71446_o.func_110577_a(resourcelocation);
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        float f4 = 0.0f;
        float f5 = 0.3f;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        if (itemstack != null && (itemstack.func_77962_s() || effect)) {
            float blue;
            float green;
            float red;
            if (effect) {
                red = (float)((double)((effectColor & 0xFF0000) >> 16) / 255.0);
                green = (float)((double)((effectColor & 0xFF00) >> 8) / 255.0);
                blue = (float)((double)(effectColor & 0xFF) / 255.0);
            } else {
                float f7 = 0.76f;
                red = 0.5f * f7;
                blue = 0.25f * f7;
                green = 0.8f * f7;
            }
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)0.5f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }
}

