/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.worldGeneration;

import com.DavidM1A2.AfraidOfTheDark.common.handler.ConfigurationHandler;
import com.DavidM1A2.AfraidOfTheDark.common.refrence.Constants;
import com.DavidM1A2.AfraidOfTheDark.common.savedData.AOTDWorldData;
import com.DavidM1A2.AfraidOfTheDark.common.schematic.SchematicGenerator;
import com.DavidM1A2.AfraidOfTheDark.common.utility.LogHelper;
import com.DavidM1A2.AfraidOfTheDark.common.utility.Point3D;
import com.DavidM1A2.AfraidOfTheDark.common.worldGeneration.AOTDDungeonTypes;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLeaves;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class GenerateGnomishCity {
    public static boolean generateSurface(World world, Random random, int chunkX, int chunkZ) {
        int j;
        int i;
        int k;
        int stairs3To4;
        int stairs1To2;
        int y = 20;
        if (!AOTDWorldData.get(world).isValidLocation(new Point3D(chunkX, AOTDDungeonTypes.GnomishCity.getRadius(), chunkZ), false)) {
            return false;
        }
        AOTDWorldData.get(world).addDungeon(new Point3D(chunkX, AOTDDungeonTypes.GnomishCity.getRadius(), chunkZ), false);
        if (ConfigurationHandler.debugMessages) {
            LogHelper.info("Spawning a gnomish city at x = " + chunkX + ", y = " + y + ", z = " + chunkZ);
        }
        chunkX -= 65;
        chunkZ -= 65;
        int stairs2To3 = 4;
        while (stairs2To3 == 4) {
            stairs2To3 = random.nextInt(9);
        }
        while ((stairs1To2 = random.nextInt(9)) == stairs2To3) {
        }
        while ((stairs3To4 = random.nextInt(9)) == stairs2To3 || stairs3To4 == stairs1To2) {
        }
        LinkedList<Integer> rooms = new LinkedList<Integer>();
        for (int i2 = 0; i2 < Constants.AOTDSchematics.rooms.size(); ++i2) {
            rooms.add(i2);
            rooms.add(i2);
        }
        Collections.shuffle(rooms, random);
        for (k = 0; k < 2; ++k) {
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    int currentRoom = i + j * 3;
                    if (currentRoom == stairs2To3) {
                        if (k == 0) {
                            SchematicGenerator.generateSchematicWithLoot(Constants.AOTDSchematics.roomStairUp, world, chunkX + i * 50, y + k * 15, chunkZ + j * 50, Constants.gnomishCityLootTable);
                            continue;
                        }
                        SchematicGenerator.generateSchematicWithLoot(Constants.AOTDSchematics.roomStairDown, world, chunkX + i * 50, y + k * 15, chunkZ + j * 50, Constants.gnomishCityLootTable);
                        continue;
                    }
                    if (currentRoom == stairs1To2 && k == 0) {
                        SchematicGenerator.generateSchematicWithLoot(Constants.AOTDSchematics.roomStairDown, world, chunkX + i * 50, y + k * 15, chunkZ + j * 50, Constants.gnomishCityLootTable);
                        SchematicGenerator.generateSchematic(Constants.AOTDSchematics.enariaLair, world, chunkX + i * 50 - 14, y + k * 15 - 15, chunkZ + j * 50 - 73);
                        continue;
                    }
                    if (currentRoom == stairs3To4 && k == 1) {
                        SchematicGenerator.generateSchematicWithLoot(Constants.AOTDSchematics.roomStairUp, world, chunkX + i * 50, y + k * 15, chunkZ + j * 50, Constants.gnomishCityLootTable);
                        SchematicGenerator.generateSchematic(Constants.AOTDSchematics.stairwell, world, chunkX + i * 50 + 13, y + k * 15 + 15, chunkZ + j * 50 + 13);
                        SchematicGenerator.generateSchematic(Constants.AOTDSchematics.stairwell, world, chunkX + i * 50 + 13, y + k * 15 + 31, chunkZ + j * 50 + 13);
                        GenerateGnomishCity.fixStairs(world, chunkX + i * 50 + 13, y + k * 15 + 47, chunkZ + j * 50 + 13);
                        continue;
                    }
                    SchematicGenerator.generateSchematicWithLoot(Constants.AOTDSchematics.rooms.get((Integer)rooms.get(0)), world, chunkX + i * 50, y + k * 15, chunkZ + j * 50, Constants.gnomishCityLootTable);
                    rooms.remove(0);
                }
            }
        }
        for (k = 0; k < 2; ++k) {
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 2; ++j) {
                    SchematicGenerator.generateSchematic(Constants.AOTDSchematics.tunnelEW, world, chunkX + i * 50 + 13, y + k * 15 + 7, chunkZ + j * 50 + 32);
                    SchematicGenerator.generateSchematic(Constants.AOTDSchematics.tunnelNS, world, chunkX + j * 50 + 32, y + k * 15 + 7, chunkZ + i * 50 + 13);
                }
            }
        }
        return true;
    }

    private static void fixStairs(World world, int x, int y, int z) {
        while (y > 5) {
            Block block1 = world.func_180495_p(new BlockPos(x + 3, y, z - 1)).func_177230_c();
            Block block2 = world.func_180495_p(new BlockPos(x - 1, y, z + 3)).func_177230_c();
            Block block3 = world.func_180495_p(new BlockPos(x + 7, y, z + 3)).func_177230_c();
            Block block4 = world.func_180495_p(new BlockPos(x + 3, y, z + 7)).func_177230_c();
            boolean levelValidToRemove = block1 instanceof BlockAir || block1 instanceof BlockLeaves;
            levelValidToRemove = levelValidToRemove && (block2 instanceof BlockAir || block2 instanceof BlockLeaves);
            levelValidToRemove = levelValidToRemove && (block3 instanceof BlockAir || block3 instanceof BlockLeaves);
            boolean bl = levelValidToRemove = levelValidToRemove && (block4 instanceof BlockAir || block4 instanceof BlockLeaves);
            if (!levelValidToRemove) {
                return;
            }
            GenerateGnomishCity.clearLevel(world, x, y, z);
            --y;
        }
    }

    private static void clearLevel(World world, int x, int y, int z) {
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                world.func_175698_g(new BlockPos(x + i, y, z + j));
            }
        }
    }
}

