/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.utility;

import com.DavidM1A2.AfraidOfTheDark.common.block.BlockGravewood;
import com.DavidM1A2.AfraidOfTheDark.common.block.BlockVoidChestPortal;
import com.DavidM1A2.AfraidOfTheDark.common.utility.UnsupportedLocationException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fluids.BlockFluidBase;

public class WorldGenerationUtility {
    public static int getFirstNonAirBlock(World world, int x, int z) throws UnsupportedLocationException {
        for (int y = 255; y > 0; --y) {
            Block current = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            if (!(current instanceof BlockAir)) {
                return y;
            }
            if (!(current instanceof BlockVoidChestPortal)) continue;
            world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150348_b.func_176223_P());
            return y;
        }
        return 0;
    }

    public static int getPlaceToSpawnAverage(World world, int x, int z, int height, int width) throws UnsupportedLocationException {
        int y1 = 0;
        int y2 = 0;
        int y3 = 0;
        int y4 = 0;
        y1 = WorldGenerationUtility.getTheYValueAtCoords(world, x, z);
        y2 = WorldGenerationUtility.getTheYValueAtCoords(world, x + width, z);
        y3 = WorldGenerationUtility.getTheYValueAtCoords(world, x, z + height);
        y4 = WorldGenerationUtility.getTheYValueAtCoords(world, x + width, z + height);
        if (y1 == 0 || y2 == 0 || y3 == 0 || y4 == 0) {
            throw new UnsupportedLocationException(y1, y2, y3, y4);
        }
        return (y1 + y2 + y3 + y4) / 4;
    }

    private static int getTheYValueAtCoords(World world, int x, int z) {
        for (int temp = 255; temp > 0; --temp) {
            Block current = world.func_180495_p(new BlockPos(x, temp, z)).func_177230_c();
            if (current instanceof BlockFluidBase) {
                return 0;
            }
            if (current instanceof BlockGrass) {
                return temp;
            }
            if (current instanceof BlockDirt) {
                if (world.func_175678_i(new BlockPos(x, temp, z))) {
                    return temp;
                }
                if (world.func_180495_p(new BlockPos(x, temp, z)) == Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL)) {
                    return temp;
                }
                if (world.func_180495_p(new BlockPos(x, temp + 1, z)).func_177230_c() instanceof BlockLog || world.func_180495_p(new BlockPos(x, temp + 1, z)).func_177230_c() instanceof BlockGravewood) {
                    return temp;
                }
            }
            if (!(world.func_180495_p(new BlockPos(x, temp + 1, z)).func_177230_c() instanceof BlockSnow)) continue;
            return temp;
        }
        return 0;
    }

    public static int getPlaceToSpawnLowest(World world, int x, int z, int height, int width) throws UnsupportedLocationException {
        int y1 = 0;
        int y2 = 0;
        int y3 = 0;
        int y4 = 0;
        y1 = WorldGenerationUtility.getTheYValueAtCoords(world, x, z);
        y2 = WorldGenerationUtility.getTheYValueAtCoords(world, x + width, z);
        y3 = WorldGenerationUtility.getTheYValueAtCoords(world, x, z + height);
        y4 = WorldGenerationUtility.getTheYValueAtCoords(world, x + width, z + height);
        if (y1 == 0 || y2 == 0 || y3 == 0 || y4 == 0) {
            throw new UnsupportedLocationException(y1, y2, y3, y4);
        }
        return Math.min(y1, Math.min(y2, Math.min(y3, y4)));
    }

    public static IBlockState setBlockStateInChunkFast(Chunk parChunk, BlockPos parBlockPos, IBlockState parIBlockState) {
        TileEntity te;
        int chunkX = parBlockPos.func_177958_n() & 0xF;
        int chunkY = parBlockPos.func_177956_o();
        int chunkZ = parBlockPos.func_177952_p() & 0xF;
        IBlockState existingIBlockState = parChunk.func_177435_g(parBlockPos);
        if (existingIBlockState == parIBlockState) {
            return null;
        }
        Block newBlock = parIBlockState.func_177230_c();
        Block existingBlock = existingIBlockState.func_177230_c();
        ExtendedBlockStorage extendedblockstorage = parChunk.func_76587_i()[chunkY >> 4];
        if (extendedblockstorage == null) {
            if (newBlock == Blocks.field_150350_a) {
                return null;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(chunkY >> 4 << 4, !parChunk.func_177412_p().field_73011_w.func_177495_o());
            parChunk.func_76587_i()[chunkY >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
        }
        extendedblockstorage.func_177484_a(chunkX, chunkY & 0xF, chunkZ, parIBlockState);
        if (!parChunk.func_177412_p().field_72995_K) {
            if (existingIBlockState.func_177230_c() != parIBlockState.func_177230_c()) {
                existingBlock.func_180663_b(parChunk.func_177412_p(), parBlockPos, existingIBlockState);
            }
            if ((te = parChunk.func_177424_a(parBlockPos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(parChunk.func_177412_p(), parBlockPos, existingIBlockState, parIBlockState)) {
                parChunk.func_177412_p().func_175713_t(parBlockPos);
            }
        } else if (existingBlock.hasTileEntity(existingIBlockState) && (te = parChunk.func_177424_a(parBlockPos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(parChunk.func_177412_p(), parBlockPos, existingIBlockState, parIBlockState)) {
            parChunk.func_177412_p().func_175713_t(parBlockPos);
        }
        if (extendedblockstorage.func_150819_a(chunkX, chunkY & 0xF, chunkZ) != newBlock) {
            return null;
        }
        if (!parChunk.func_177412_p().field_72995_K && existingBlock != newBlock) {
            newBlock.func_176213_c(parChunk.func_177412_p(), parBlockPos, parIBlockState);
        }
        if (newBlock.hasTileEntity(parIBlockState)) {
            TileEntity tileentity = parChunk.func_177424_a(parBlockPos, Chunk.EnumCreateEntityType.CHECK);
            if (tileentity == null) {
                tileentity = newBlock.createTileEntity(parChunk.func_177412_p(), parIBlockState);
                parChunk.func_177412_p().func_175690_a(parBlockPos, tileentity);
            }
            if (tileentity != null) {
                tileentity.func_145836_u();
            }
        }
        parChunk.func_177427_f(true);
        return existingIBlockState;
    }

    public static boolean setBlockStateFast(World parWorld, BlockPos parBlockPos, IBlockState parIBlockState, int parFlags) {
        IBlockState theIBlockState;
        if (parBlockPos.func_177958_n() < -30000000 || parBlockPos.func_177952_p() < -30000000 || parBlockPos.func_177958_n() >= 30000000 || parBlockPos.func_177952_p() >= 30000000 || parBlockPos.func_177956_o() < 0 || parBlockPos.func_177956_o() >= 256) {
            return false;
        }
        if (!parWorld.field_72995_K && parWorld.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk theChunk = parWorld.func_175726_f(parBlockPos);
        BlockSnapshot blockSnapshot = null;
        if (parWorld.captureBlockSnapshots && !parWorld.field_72995_K) {
            blockSnapshot = BlockSnapshot.getBlockSnapshot((World)parWorld, (BlockPos)parBlockPos, (int)parFlags);
            parWorld.capturedBlockSnapshots.add(blockSnapshot);
        }
        if ((theIBlockState = WorldGenerationUtility.setBlockStateInChunkFast(theChunk, parBlockPos, parIBlockState)) == null) {
            if (blockSnapshot != null) {
                parWorld.capturedBlockSnapshots.remove(blockSnapshot);
            }
            return false;
        }
        if (blockSnapshot == null) {
            parWorld.markAndNotifyBlock(parBlockPos, theChunk, theIBlockState, parIBlockState, parFlags);
        }
        return true;
    }
}

