/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.savedData;

import com.DavidM1A2.AfraidOfTheDark.AfraidOfTheDark;
import com.DavidM1A2.AfraidOfTheDark.common.handler.ConfigurationHandler;
import com.DavidM1A2.AfraidOfTheDark.common.packets.SyncAOTDEntityData;
import com.DavidM1A2.AfraidOfTheDark.common.packets.SyncAOTDPlayerData;
import com.DavidM1A2.AfraidOfTheDark.common.packets.UpdateVitae;
import com.DavidM1A2.AfraidOfTheDark.common.refrence.Constants;
import com.DavidM1A2.AfraidOfTheDark.common.utility.LogHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class AOTDEntityData
implements IExtendedEntityProperties {
    private final Entity entity;
    private int vitae = 0;
    private static final String VITAE_LEVEL = "vitaeLevel";

    public AOTDEntityData(Entity entity) {
        this.entity = entity;
    }

    private static String getIdentifier() {
        return "AOTDEntityData";
    }

    public static AOTDEntityData get(Entity entity) {
        return (AOTDEntityData)entity.getExtendedProperties(AOTDEntityData.getIdentifier());
    }

    public static void register(Entity entity) {
        if (entity.getExtendedProperties(AOTDEntityData.getIdentifier()) == null) {
            entity.registerExtendedProperties(AOTDEntityData.getIdentifier(), (IExtendedEntityProperties)new AOTDEntityData(entity));
        }
    }

    public void saveNBTData(NBTTagCompound nbt) {
        nbt.func_74768_a(VITAE_LEVEL, this.vitae);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        if (nbt.func_74764_b(VITAE_LEVEL)) {
            this.setVitaeLevel(nbt.func_74762_e(VITAE_LEVEL));
        }
    }

    public void init(Entity entity, World world) {
    }

    public boolean isServerSide() {
        return this.entity != null && this.entity.field_70170_p != null && !this.entity.field_70170_p.field_72995_K;
    }

    public int getVitaeLevel() {
        return this.vitae;
    }

    public boolean setVitaeLevel(int vitaeLevel) {
        boolean boom = false;
        if (Constants.entityVitaeResistance.containsKey(this.entity.getClass())) {
            boom = vitaeLevel > Constants.entityVitaeResistance.get(this.entity.getClass());
            this.vitae = MathHelper.func_76125_a((int)vitaeLevel, (int)0, (int)Integer.MAX_VALUE);
        } else if (ConfigurationHandler.debugMessages) {
            LogHelper.warn(this.entity.getClass().getSimpleName() + " is not registered in the vitae dictionary and therefore cannot receive vitae.");
        }
        return boom;
    }

    public void syncVitaeLevel() {
        if (this.isServerSide()) {
            AfraidOfTheDark.getPacketHandler().sendToAll(new UpdateVitae(this.getVitaeLevel(), this.entity.func_145782_y()));
        } else {
            AfraidOfTheDark.getPacketHandler().sendToServer(new UpdateVitae(this.getVitaeLevel(), this.entity.func_145782_y()));
        }
    }

    public void syncAll() {
        if (this.isServerSide() && this.entity instanceof EntityPlayer) {
            AfraidOfTheDark.getPacketHandler().sendTo(new SyncAOTDEntityData(this), (EntityPlayerMP)this.entity);
        }
    }

    public void requestSyncAll() {
        if (!this.isServerSide()) {
            AfraidOfTheDark.getPacketHandler().sendToServer(new SyncAOTDPlayerData());
        }
    }
}

