/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.recipe;

import com.DavidM1A2.AfraidOfTheDark.common.recipe.ConvertedRecipe;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeUtility {
    public static List<ConvertedRecipe> getRecipesForItem(Item item) {
        LinkedList<ConvertedRecipe> convertedRecipes = new LinkedList<ConvertedRecipe>();
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            ConvertedRecipe cleanedRecipe;
            IRecipe currentRecipe;
            if (!(recipe instanceof IRecipe) || (currentRecipe = (IRecipe)recipe).func_77571_b() == null || currentRecipe.func_77571_b().func_77973_b() != item || (cleanedRecipe = RecipeUtility.getConvertedRecipeFromIRecipe(currentRecipe)) == null) continue;
            convertedRecipes.add(cleanedRecipe);
        }
        return convertedRecipes;
    }

    private static ConvertedRecipe getConvertedRecipeFromIRecipe(IRecipe currentRecipe) {
        List requiredItems;
        List oreDictionaryList;
        Object object;
        int i;
        int width = 0;
        int height = 0;
        ItemStack output = currentRecipe.func_77571_b();
        ItemStack[] input = null;
        if (currentRecipe instanceof ShapedRecipes) {
            ShapedRecipes shapedRecipe = (ShapedRecipes)currentRecipe;
            width = shapedRecipe.field_77576_b;
            height = shapedRecipe.field_77577_c;
            input = shapedRecipe.field_77574_d;
        } else if (currentRecipe instanceof ShapedOreRecipe) {
            ShapedOreRecipe shapedOreRecipe = (ShapedOreRecipe)currentRecipe;
            Field[] fields = ShapedOreRecipe.class.getDeclaredFields();
            fields[4].setAccessible(true);
            fields[5].setAccessible(true);
            try {
                width = (Integer)fields[4].get(shapedOreRecipe);
                height = (Integer)fields[5].get(shapedOreRecipe);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fields[4].setAccessible(false);
            fields[5].setAccessible(false);
            input = new ItemStack[shapedOreRecipe.getInput().length];
            for (i = 0; i < shapedOreRecipe.getInput().length; ++i) {
                object = shapedOreRecipe.getInput()[i];
                if (object instanceof Item) {
                    input[i] = new ItemStack((Item)object, 1, 0);
                    continue;
                }
                if (object instanceof Block) {
                    input[i] = new ItemStack((Block)object, 1, 0);
                    continue;
                }
                if (object instanceof ItemStack) {
                    input[i] = (ItemStack)object;
                    continue;
                }
                if (!(object instanceof List) || (oreDictionaryList = (List)object).isEmpty()) continue;
                input[i] = (ItemStack)oreDictionaryList.get(0);
            }
        } else if (currentRecipe instanceof ShapelessRecipes) {
            ShapelessRecipes shapelessRecipe = (ShapelessRecipes)currentRecipe;
            width = -1;
            height = -1;
            requiredItems = shapelessRecipe.field_77579_b;
            input = new ItemStack[requiredItems.size()];
            for (i = 0; i < requiredItems.size(); ++i) {
                object = requiredItems.get(i);
                input[i] = object instanceof Item ? new ItemStack((Item)object, 1, 0) : (object instanceof Block ? new ItemStack((Block)object, 1, 0) : (ItemStack)object);
            }
        } else if (currentRecipe instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe shapelessOreRecipe = (ShapelessOreRecipe)currentRecipe;
            width = -1;
            height = -1;
            input = new ItemStack[shapelessOreRecipe.getInput().size()];
            requiredItems = shapelessOreRecipe.getInput();
            for (i = 0; i < requiredItems.size(); ++i) {
                object = requiredItems.get(i);
                if (object instanceof Item) {
                    input[i] = new ItemStack((Item)object, 1, 0);
                    continue;
                }
                if (object instanceof Block) {
                    input[i] = new ItemStack((Block)object, 1, 0);
                    continue;
                }
                if (object instanceof ItemStack) {
                    input[i] = (ItemStack)object;
                    continue;
                }
                if (!(object instanceof List) || (oreDictionaryList = (List)object).isEmpty()) continue;
                input[i] = (ItemStack)oreDictionaryList.get(0);
            }
        }
        ConvertedRecipe cleanedRecipe = new ConvertedRecipe(width, height, output, input);
        for (ItemStack itemStack : cleanedRecipe.getInput()) {
            if (itemStack == null || itemStack.func_77952_i() != Short.MAX_VALUE) continue;
            itemStack.func_77964_b(0);
        }
        if (cleanedRecipe.getOutput().func_77952_i() == Short.MAX_VALUE) {
            cleanedRecipe.getOutput().func_77964_b(0);
        }
        if (width != 0) {
            return cleanedRecipe;
        }
        return null;
    }
}

