/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.item.core;

import com.DavidM1A2.AfraidOfTheDark.common.item.core.AOTDSword;
import com.DavidM1A2.AfraidOfTheDark.common.utility.NBTHelper;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AOTDChargableSword
extends AOTDSword {
    private final String itemName;

    public AOTDChargableSword(Item.ToolMaterial material, String itemName) {
        super(material);
        this.itemName = itemName;
        this.func_77655_b(itemName);
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        if (target instanceof EntityPlayer || target instanceof EntityLiving) {
            if (NBTHelper.getInt(itemStack, "charge") < 100) {
                NBTHelper.setInteger(itemStack, "charge", NBTHelper.getInt(itemStack, "charge") + this.percentChargePerAttack());
            }
            if (NBTHelper.getInt(itemStack, "charge") > 100) {
                NBTHelper.setInteger(itemStack, "charge", 100);
            }
        }
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0 - (double)NBTHelper.getInt(itemStack, "charge") / 100.0;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    public int getMetadata(ItemStack itemStack) {
        return NBTHelper.getInt(itemStack, "charge") == 100 ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        return stack.func_77960_j() == 1 ? new ModelResourceLocation("AfraidOfTheDark:" + this.itemName + "FullCharge", "inventory") : new ModelResourceLocation("AfraidOfTheDark:" + this.itemName, "inventory");
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!world.field_72995_K) {
            if (NBTHelper.getInt(itemStack, "charge") >= 100) {
                NBTHelper.setInteger(itemStack, "charge", 0);
                this.performChargeAttack(itemStack, world, entityPlayer);
            } else {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("I'll need more energy to perform the ability."));
            }
        }
        return itemStack;
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemStackLimit(stack) == 1;
    }

    public abstract int percentChargePerAttack();

    public abstract void performChargeAttack(ItemStack var1, World var2, EntityPlayer var3);
}

