/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.entities.Enaria;

import com.DavidM1A2.AfraidOfTheDark.AfraidOfTheDark;
import com.DavidM1A2.AfraidOfTheDark.common.entities.Enaria.EntityEnaria;
import com.DavidM1A2.AfraidOfTheDark.common.entities.EnchantedSkeleton.EntityEnchantedSkeleton;
import com.DavidM1A2.AfraidOfTheDark.common.entities.SplinterDrone.EntitySplinterDrone;
import com.DavidM1A2.AfraidOfTheDark.common.entities.Werewolf.EntityWerewolf;
import com.DavidM1A2.AfraidOfTheDark.common.packets.SyncParticleFX;
import com.DavidM1A2.AfraidOfTheDark.common.refrence.AOTDParticleFXTypes;
import com.DavidM1A2.AfraidOfTheDark.common.utility.Utility;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class EnariaAttacks {
    private final EntityEnaria enaria;
    private final Random random;
    private static final int POTION_POISON_RANGE = 20;
    private static final int DARKNESS_RANGE = 100;
    private static final int TELEPORT_RANGE = 20;
    private static final double KNOCKBACK_POWER = 5.0;
    private static final int MAX_KNOCKBACK_RANGE = 10;
    private static final int TELEPORT_PLAYER_RANGE = 80;
    private static final int BASIC_RANGE = 20;
    private static final int NUMBER_OF_PARTICLES_PER_ATTACK = 30;
    private static final int NUMBER_OF_PARTICLES_PER_TELEPORT = 30;
    private static final int RAY_TELEPORT_RANGE = 120;
    private static final int SHUFFLE_INVENTORY_RANGE = 30;
    private static final int SIGHT_RANGE = 130;
    private final PotionEffect[] possibleEffects;

    public EnariaAttacks(EntityEnaria enaria, Random random) {
        this.enaria = enaria;
        this.random = random;
        this.possibleEffects = new PotionEffect[]{new PotionEffect(Potion.field_76421_d.func_76396_c(), 300, 0, false, true), new PotionEffect(Potion.field_76419_f.func_76396_c(), 300, 1, false, true), new PotionEffect(Potion.field_76433_i.func_76396_c(), 1, 2, false, true), new PotionEffect(Potion.field_76431_k.func_76396_c(), 350, 0, false, true), new PotionEffect(Potion.field_76440_q.func_76396_c(), 100, 0, false, true), new PotionEffect(Potion.field_76438_s.func_76396_c(), 100, 10, false, true), new PotionEffect(Potion.field_76437_t.func_76396_c(), 100, 4, false, true), new PotionEffect(Potion.field_76436_u.func_76396_c(), 100, 3, false, true), new PotionEffect(Potion.field_82731_v.func_76396_c(), 100, 2, false, true)};
    }

    public void performBasicAttack() {
        for (Object object : this.enaria.field_70170_p.func_72872_a(EntityPlayer.class, this.enaria.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0))) {
            if (!(object instanceof EntityPlayer)) continue;
            EntityPlayer entityPlayer = (EntityPlayer)object;
            entityPlayer.func_70097_a(EntityDamageSource.func_76358_a((EntityLivingBase)this.enaria), (float)this.enaria.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            this.performBasicAttackParticleEffectTo(entityPlayer);
        }
    }

    private void performBasicAttackParticleEffectTo(EntityPlayer entityPlayer) {
        for (int i = 0; i < 30; ++i) {
            int x = (int)Math.round(this.enaria.field_70165_t + (entityPlayer.field_70165_t - this.enaria.field_70165_t) * (double)i / 30.0);
            int y = 1 + (int)Math.round(this.enaria.field_70163_u + (entityPlayer.field_70163_u - this.enaria.field_70163_u) * (double)i / 30.0);
            int z = (int)Math.round(this.enaria.field_70161_v + (entityPlayer.field_70161_v - this.enaria.field_70161_v) * (double)i / 30.0);
            if (entityPlayer.field_70170_p.field_72995_K) continue;
            AfraidOfTheDark.getPacketHandler().sendToAllAround(new SyncParticleFX(AOTDParticleFXTypes.EnariaBasicAttack, x, y, z), new NetworkRegistry.TargetPoint(entityPlayer.field_71093_bK, (double)x, (double)y, (double)z, 40.0));
        }
    }

    public void randomTeleport() {
        if (!this.enaria.field_70170_p.field_72995_K) {
            for (int i = 0; i < 30; ++i) {
                AfraidOfTheDark.getPacketHandler().sendToAllAround(new SyncParticleFX(AOTDParticleFXTypes.EnariaTeleport, (double)this.enaria.func_180425_c().func_177958_n() + Math.random(), (double)this.enaria.func_180425_c().func_177956_o() + 0.7 + Math.random(), (double)this.enaria.func_180425_c().func_177952_p() + Math.random()), new NetworkRegistry.TargetPoint(this.enaria.field_71093_bK, (double)this.enaria.func_180425_c().func_177958_n() + Math.random(), (double)this.enaria.func_180425_c().func_177956_o() + 0.7 + Math.random(), (double)this.enaria.func_180425_c().func_177952_p() + Math.random(), 40.0));
            }
            List entityList = this.enaria.field_70170_p.func_72872_a(EntityPlayer.class, this.enaria.func_174813_aQ().func_72314_b(80.0, 80.0, 80.0));
            for (Object entityObject : entityList) {
                if (!(entityObject instanceof EntityPlayer)) continue;
                EntityPlayer entityPlayer = (EntityPlayer)entityObject;
                this.enaria.func_70690_d(new PotionEffect(Potion.field_76441_p.func_76396_c(), 60, 0, false, false));
                this.teleportWithShockwave(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v);
                return;
            }
        }
    }

    private void teleportWithShockwave(double x, double y, double z) {
        this.enaria.func_70107_b(x, y, z);
        this.enaria.func_70690_d(new PotionEffect(14, 40, 0, false, false));
        List entityList = this.enaria.field_70170_p.func_72872_a(EntityPlayer.class, this.enaria.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
        for (Object entityObject : entityList) {
            if (!(entityObject instanceof EntityPlayer)) continue;
            EntityPlayer entityPlayer = (EntityPlayer)entityObject;
            double motionX = this.enaria.func_180425_c().func_177958_n() - entityPlayer.func_180425_c().func_177958_n();
            double motionZ = this.enaria.func_180425_c().func_177952_p() - entityPlayer.func_180425_c().func_177952_p();
            double hypotenuse = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
            entityPlayer.func_70024_g(-motionX * 5.0 * (double)0.6f / hypotenuse, 0.1, -motionZ * 5.0 * (double)0.6f / hypotenuse);
            entityPlayer.field_70133_I = true;
        }
    }

    public void performRandomAttack() {
        int attackToPerform = this.random.nextInt(12);
        switch (attackToPerform) {
            case 0: 
            case 1: {
                this.attackSummonWerewolves();
                break;
            }
            case 2: 
            case 3: {
                this.attackAOEPotion();
                break;
            }
            case 4: {
                this.attackShuffleInventory();
                break;
            }
            case 5: 
            case 6: {
                this.attackSummonEnchantedSkeletons();
                break;
            }
            case 7: {
                this.teleportToPlayer();
                break;
            }
            case 8: 
            case 9: {
                this.attackDarkness();
                break;
            }
            case 10: 
            case 11: {
                this.attackSummonSplinterDrones();
            }
        }
    }

    private void attackDarkness() {
        for (Object object : this.enaria.field_70170_p.func_72872_a(EntityPlayer.class, this.enaria.func_174813_aQ().func_72314_b(100.0, 100.0, 100.0))) {
            if (!(object instanceof EntityPlayer)) continue;
            EntityPlayer entityPlayer = (EntityPlayer)object;
            this.enaria.field_70170_p.func_72956_a((Entity)entityPlayer, "mob.wither.hurt", 1.0f, 0.5f);
            if (entityPlayer.func_82165_m(Potion.field_76439_r.func_76396_c())) {
                entityPlayer.func_82170_o(Potion.field_76439_r.func_76396_c());
            }
            entityPlayer.func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), 260, 0, false, false));
        }
        for (int i = this.enaria.func_180425_c().func_177958_n() - 5; i < this.enaria.func_180425_c().func_177958_n() + 5; ++i) {
            for (int j = this.enaria.func_180425_c().func_177956_o() - 5; j < this.enaria.func_180425_c().func_177956_o() + 5; ++j) {
                for (int k = this.enaria.func_180425_c().func_177952_p() - 5; k < this.enaria.func_180425_c().func_177952_p() + 5; ++k) {
                    BlockPos current = new BlockPos(i, j, k);
                    if (!(this.enaria.field_70170_p.func_180495_p(current).func_177230_c() instanceof BlockTorch)) continue;
                    this.enaria.field_70170_p.func_175698_g(current);
                }
            }
        }
    }

    public void attackShuffleInventory() {
        if (!this.enaria.field_70170_p.field_72995_K) {
            for (Object object : this.enaria.field_70170_p.func_72872_a(EntityPlayer.class, this.enaria.func_174813_aQ().func_72314_b(30.0, 30.0, 30.0))) {
                if (!(object instanceof EntityPlayer)) continue;
                EntityPlayer entityPlayer = (EntityPlayer)object;
                if (entityPlayer.field_71075_bZ.field_75098_d) continue;
                Collections.shuffle(Arrays.asList(entityPlayer.field_71071_by.field_70462_a));
            }
        }
    }

    public void attackSummonWerewolves() {
        if (!this.enaria.field_70170_p.field_72995_K) {
            int numberOfWWsSpawned = 0;
            int maxWWsSpawned = this.random.nextInt(3) + 2;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos current;
                IBlockState block;
                if (numberOfWWsSpawned >= maxWWsSpawned || !((block = this.enaria.field_70170_p.func_180495_p(current = this.enaria.func_180425_c().func_177972_a(facing))).func_177230_c() instanceof BlockAir)) continue;
                EntityWerewolf werewolf = new EntityWerewolf(this.enaria.field_70170_p);
                werewolf.func_70107_b(current.func_177958_n(), current.func_177956_o(), current.func_177952_p());
                werewolf.setCanAttackAnyone(true);
                this.enaria.field_70170_p.func_72838_d((Entity)werewolf);
                ++numberOfWWsSpawned;
            }
            if (numberOfWWsSpawned == 0) {
                this.randomTeleport();
            }
        }
    }

    public void attackSummonSplinterDrones() {
        if (!this.enaria.field_70170_p.field_72995_K) {
            int numberOfSplintersSpawned = 0;
            int maxSplintersSpawned = this.random.nextInt(2) + 1;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                if (numberOfSplintersSpawned >= maxSplintersSpawned) continue;
                System.out.println(numberOfSplintersSpawned + "    :    " + maxSplintersSpawned);
                BlockPos current = this.enaria.func_180425_c().func_177972_a(facing).func_177984_a();
                IBlockState block = this.enaria.field_70170_p.func_180495_p(current);
                if (!(block.func_177230_c() instanceof BlockAir)) continue;
                EntitySplinterDrone splinterDrone = new EntitySplinterDrone(this.enaria.field_70170_p);
                splinterDrone.func_70107_b(current.func_177958_n(), current.func_177956_o(), current.func_177952_p());
                this.enaria.field_70170_p.func_72838_d((Entity)splinterDrone);
                ++numberOfSplintersSpawned;
            }
            if (numberOfSplintersSpawned == 0) {
                this.randomTeleport();
            }
        }
    }

    public void attackSummonEnchantedSkeletons() {
        if (!this.enaria.field_70170_p.field_72995_K) {
            int numberOfSkeletonsSpawned = 0;
            int maxSkeletonsSpawned = this.random.nextInt(6) + 4;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos current;
                IBlockState block;
                if (numberOfSkeletonsSpawned >= maxSkeletonsSpawned || !((block = this.enaria.field_70170_p.func_180495_p(current = this.enaria.func_180425_c().func_177972_a(facing).func_177984_a())).func_177230_c() instanceof BlockAir)) continue;
                EntityEnchantedSkeleton enchantedSkeleton = new EntityEnchantedSkeleton(this.enaria.field_70170_p);
                enchantedSkeleton.func_70107_b(current.func_177958_n(), current.func_177956_o(), current.func_177952_p());
                this.enaria.field_70170_p.func_72838_d((Entity)enchantedSkeleton);
                EntityEnchantedSkeleton enchantedSkeleton2 = new EntityEnchantedSkeleton(this.enaria.field_70170_p);
                enchantedSkeleton2.func_70107_b(current.func_177958_n(), current.func_177956_o(), current.func_177952_p());
                this.enaria.field_70170_p.func_72838_d((Entity)enchantedSkeleton2);
                numberOfSkeletonsSpawned += 2;
            }
            if (numberOfSkeletonsSpawned == 0) {
                this.randomTeleport();
            }
        }
    }

    public void attackAOEPotion() {
        if (!this.enaria.field_70170_p.field_72995_K) {
            for (Object object : this.enaria.field_70170_p.func_72872_a(EntityPlayer.class, this.enaria.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0))) {
                if (!(object instanceof EntityPlayer)) continue;
                EntityPlayer entityPlayer = (EntityPlayer)object;
                if (entityPlayer.field_71075_bZ.field_75098_d) continue;
                Collections.shuffle(Arrays.asList(this.possibleEffects), this.enaria.func_70681_au());
                entityPlayer.func_70690_d(this.possibleEffects[0]);
                entityPlayer.func_70690_d(this.possibleEffects[1]);
                entityPlayer.func_70690_d(this.possibleEffects[2]);
            }
        }
    }

    private void teleportToPlayer() {
        List entityList = this.enaria.field_70170_p.func_72872_a(EntityPlayer.class, this.enaria.func_174813_aQ().func_72314_b(80.0, 80.0, 80.0));
        for (Object entityObject : entityList) {
            if (!(entityObject instanceof EntityPlayer)) continue;
            EntityPlayer entityPlayer = (EntityPlayer)entityObject;
            entityPlayer.func_70606_j(entityPlayer.func_110143_aJ() - 5.0f);
            this.enaria.func_70107_b(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v);
            this.enaria.func_70690_d(new PotionEffect(Potion.field_76429_m.func_76396_c(), 20, 99, false, false));
            entityPlayer.func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), 30, 0, false, false));
            if (this.enaria.field_70170_p instanceof WorldServer) {
                Utility.createExplosionWithoutBlockDamageServer(this.enaria.field_70170_p, (Entity)entityPlayer, this.enaria.field_70165_t, this.enaria.field_70163_u, this.enaria.field_70161_v, 7, false, true);
            } else {
                Utility.createExplosionWithoutBlockDamageClient(this.enaria.field_70170_p, (Entity)entityPlayer, this.enaria.field_70165_t, this.enaria.field_70163_u, this.enaria.field_70161_v, 7, false, true);
            }
            return;
        }
    }
}

