/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.commands;

import com.DavidM1A2.AfraidOfTheDark.common.savedData.AOTDWorldData;
import com.DavidM1A2.AfraidOfTheDark.common.utility.Point3D;
import com.DavidM1A2.AfraidOfTheDark.common.worldGeneration.AOTDDungeonTypes;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class AfraidOfTheDarkCommands
extends CommandBase {
    private final List aliases = new ArrayList();

    public AfraidOfTheDarkCommands() {
        this.aliases.add("AOTD");
        this.aliases.add("AfraidOfTheDark");
    }

    public String func_71517_b() {
        return "printDungeons";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/AOTD OR /AfraidOfTheDark";
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1 && args[0].equalsIgnoreCase("printDungeons")) {
            this.printKnownDungeons(sender);
        } else if (args.length == 1 && args[0].equalsIgnoreCase("help") || args.length == 0) {
            this.printHelp(sender);
        }
    }

    public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 0) {
            return AfraidOfTheDarkCommands.func_71530_a((String[])args, (String[])new String[]{"AOTD", "AfraidOfTheDark"});
        }
        if (args.length == 1) {
            return AfraidOfTheDarkCommands.func_71530_a((String[])args, (String[])new String[]{"printDungeons", "help"});
        }
        return null;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }

    public int compareTo(Object object) {
        return this.func_71517_b().compareTo(((ICommand)object).func_71517_b());
    }

    private void printKnownDungeons(ICommandSender sender) {
        boolean validSender = false;
        if (sender.func_174793_f() instanceof EntityPlayer) {
            if (((EntityPlayer)sender).func_70003_b(2, "") || MinecraftServer.func_71276_C().func_71264_H()) {
                validSender = true;
            }
        } else if (MinecraftServer.func_71276_C().func_71262_S()) {
            validSender = true;
        }
        if (!validSender) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You do not have permission to use this command"));
            return;
        }
        String writeDirectory = System.getProperty("user.dir") + "\\AOTDDungeons.txt";
        File file = new File(writeDirectory);
        try {
            String toPrint;
            AOTDDungeonTypes dungeon;
            BufferedWriter output = new BufferedWriter(new FileWriter(file));
            output.write("Known dungeons above ground: \n");
            for (Point3D point3d : AOTDWorldData.get(sender.func_130014_f_()).getDungeonsAboveGround()) {
                dungeon = AOTDDungeonTypes.getDungeonFromRadius(point3d.getY());
                if (dungeon == null) continue;
                toPrint = dungeon.getName() + " at x = " + point3d.getX() + ", z = " + point3d.getZ() + ".\n";
                output.write(toPrint);
            }
            output.write("\n\n");
            output.write("Known dungeons below ground: \n");
            for (Point3D point3d : AOTDWorldData.get(sender.func_130014_f_()).getDungeonsBelowGround()) {
                dungeon = AOTDDungeonTypes.getDungeonFromRadius(point3d.getY());
                if (dungeon == null) continue;
                toPrint = dungeon.getName() + " at x = " + point3d.getX() + ", z = " + point3d.getZ() + ".\n";
                output.write(toPrint);
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText("Wrote all known AOTD Dungeons in this world to\n" + writeDirectory));
            ((Writer)output).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void printHelp(ICommandSender sender) {
        sender.func_145747_a((IChatComponent)new ChatComponentText("/AOTD and /AfraidOfTheDark both work for all commands:"));
        sender.func_145747_a((IChatComponent)new ChatComponentText("/AOTD help - Lists all AOTD Commands"));
        sender.func_145747_a((IChatComponent)new ChatComponentText("/AOTD printDungeons - Prints all known AOTD dungeons to the .minecraft folder. Only works if opped"));
    }
}

