/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.block.tileEntity;

import com.DavidM1A2.AfraidOfTheDark.AfraidOfTheDark;
import com.DavidM1A2.AfraidOfTheDark.common.block.core.AOTDTileEntity;
import com.DavidM1A2.AfraidOfTheDark.common.initializeMod.ModBlocks;
import com.DavidM1A2.AfraidOfTheDark.common.packets.SyncVoidChest;
import com.DavidM1A2.AfraidOfTheDark.common.savedData.AOTDPlayerData;
import com.DavidM1A2.AfraidOfTheDark.common.utility.NBTHelper;
import com.DavidM1A2.AfraidOfTheDark.common.utility.Utility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class TileEntityVoidChest
extends AOTDTileEntity {
    public float lidAngle;
    public float prevLidAngle;
    private boolean shouldBeOpen = false;
    private int ticksSinceSync;
    private int cachedChestType;
    private String owner = "";
    private List<String> friends = new ArrayList<String>();
    private int locationToGoTo = -1;
    private EntityPlayer entityPlayerToSend = null;
    private int coordinateToSendTo = -1;
    private long lastInteraction = -1L;

    public TileEntityVoidChest() {
        super(ModBlocks.voidChest);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.owner = compound.func_74779_i("owner");
        this.locationToGoTo = compound.func_74762_e("location");
        NBTTagList friends = compound.func_150295_c("friends", 8);
        for (int i = 0; i < friends.func_74745_c(); ++i) {
            NBTBase friend = friends.func_179238_g(i);
            if (!(friend instanceof NBTTagString)) continue;
            this.friends.add(((NBTTagString)friend).func_150285_a_());
        }
        super.func_145839_a(compound);
    }

    public void func_145841_b(NBTTagCompound compound) {
        compound.func_74778_a("owner", this.owner);
        compound.func_74768_a("location", this.locationToGoTo);
        NBTTagList friends = new NBTTagList();
        for (int i = 0; i < this.friends.size(); ++i) {
            String string = this.friends.get(i);
            if (string == null) continue;
            NBTTagString friend = new NBTTagString(string);
            friends.func_74742_a((NBTBase)friend);
        }
        compound.func_74782_a("friends", (NBTBase)friends);
        super.func_145841_b(compound);
    }

    @Override
    public void func_73660_a() {
        double d2;
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (this.ticksSinceSync % 20 == 0 && System.currentTimeMillis() - this.lastInteraction > 3000L) {
            this.shouldBeOpen = false;
        }
        this.prevLidAngle = this.lidAngle;
        float f = 0.1f;
        if (this.shouldBeOpen && this.lidAngle == 0.0f) {
            double d1 = (double)i + 0.5;
            d2 = (double)k + 0.5;
            this.field_145850_b.func_72908_a(d1, (double)j + 0.5, d2, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.shouldBeOpen) {
            double xVelocity = (double)this.field_174879_c.func_177958_n() + 0.5 - this.entityPlayerToSend.field_70165_t;
            double yVelocity = (double)this.field_174879_c.func_177956_o() + 0.5 - this.entityPlayerToSend.field_70163_u;
            double zVelocity = (double)this.field_174879_c.func_177952_p() + 0.5 - this.entityPlayerToSend.field_70161_v;
            xVelocity = MathHelper.func_151237_a((double)xVelocity, (double)-0.05, (double)0.05);
            yVelocity = MathHelper.func_151237_a((double)yVelocity, (double)-0.05, (double)0.05);
            zVelocity = MathHelper.func_151237_a((double)zVelocity, (double)-0.05, (double)0.05);
            this.entityPlayerToSend.func_70024_g(xVelocity, yVelocity, zVelocity);
        }
        if (!this.shouldBeOpen && this.lidAngle > 0.0f || this.shouldBeOpen && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.shouldBeOpen ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                d2 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                this.field_145850_b.func_72908_a(d2, (double)j + 0.5, d0, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
                if (this.field_145850_b.field_73011_w.func_177502_q() != 68) {
                    for (Object object : this.field_145850_b.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177963_a(0.625, 0.625, 0.625)).func_72314_b(2.0, 2.0, 2.0))) {
                        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)object;
                        if (entityPlayerMP != this.entityPlayerToSend) continue;
                        Utility.sendPlayerToVoidChest(entityPlayerMP, this.locationToGoTo);
                    }
                }
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void interact(EntityPlayer entityPlayer) {
        if (!entityPlayer.field_70170_p.field_72995_K) {
            if (this.owner.equals("")) {
                this.owner = entityPlayer.func_145748_c_().func_150260_c();
                this.locationToGoTo = this.validatePlayerLocationVoidChest(AOTDPlayerData.get(entityPlayer).getPlayerLocationVoidChest(), entityPlayer);
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("The owner of this chest has been set to " + entityPlayer.func_145748_c_().func_150260_c() + "."));
            } else if (entityPlayer.func_145748_c_().func_150260_c().equals(this.owner)) {
                ItemStack itemStack;
                if (entityPlayer.func_71045_bC() != null && (itemStack = entityPlayer.func_71045_bC()).func_77973_b() instanceof ItemNameTag) {
                    if (!this.friends.contains(itemStack.func_82833_r())) {
                        this.friends.add(itemStack.func_82833_r());
                        if (!this.field_145850_b.field_72995_K) {
                            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Player " + itemStack.func_82833_r() + " was added to this chest's friend list."));
                        }
                    } else {
                        this.friends.remove(itemStack.func_82833_r());
                        if (!this.field_145850_b.field_72995_K) {
                            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Player " + itemStack.func_82833_r() + " was removed from this chest's friend list."));
                        }
                    }
                    return;
                }
                this.openChest(entityPlayer);
                AfraidOfTheDark.getPacketHandler().sendToAllAround(new SyncVoidChest(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), entityPlayer.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.func_177502_q(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 30.0));
            } else if (this.friends.contains(entityPlayer.func_145748_c_().func_150260_c())) {
                ItemStack itemStack;
                if (entityPlayer.func_71045_bC() != null && (itemStack = entityPlayer.func_71045_bC()).func_77973_b() instanceof ItemNameTag) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("I can't edit access to this chest"));
                    return;
                }
                this.openChest(entityPlayer);
                AfraidOfTheDark.getPacketHandler().sendToAllAround(new SyncVoidChest(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), entityPlayer.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.func_177502_q(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 30.0));
            } else {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("I don't have access to this chest."));
            }
        }
    }

    public void openChest(EntityPlayer entityPlayer) {
        this.lastInteraction = System.currentTimeMillis();
        this.shouldBeOpen = true;
        this.entityPlayerToSend = entityPlayer;
    }

    private int validatePlayerLocationVoidChest(int locationX, EntityPlayer entityPlayer) {
        if (locationX == 0) {
            if (!entityPlayer.field_70170_p.field_72995_K) {
                MinecraftServer.func_71276_C().func_71187_D().func_71556_a((ICommandSender)MinecraftServer.func_71276_C(), "/save-all");
            }
            int furthestOutPlayer = 0;
            for (NBTTagCompound entityPlayerData : NBTHelper.getOfflinePlayerNBTs()) {
                furthestOutPlayer = Math.max(furthestOutPlayer, AOTDPlayerData.getPlayerLocationVoidChestOffline(entityPlayerData));
            }
            AOTDPlayerData.get(entityPlayer).setPlayerLocationVoidChest(furthestOutPlayer + 1);
        }
        return AOTDPlayerData.get(entityPlayer).getPlayerLocationVoidChest();
    }
}

