/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.block;

import com.DavidM1A2.AfraidOfTheDark.common.block.core.AOTDBlock;
import com.DavidM1A2.AfraidOfTheDark.common.dimension.voidChest.VoidChestTeleporter;
import com.DavidM1A2.AfraidOfTheDark.common.refrence.ResearchTypes;
import com.DavidM1A2.AfraidOfTheDark.common.savedData.AOTDPlayerData;
import com.DavidM1A2.AfraidOfTheDark.common.utility.NBTHelper;
import com.DavidM1A2.AfraidOfTheDark.common.utility.Utility;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockVoidChestPortal
extends AOTDBlock {
    private long lastTimeEntered = 0L;
    private static final int TIME_INBETWEEN_MESSAGES = 3000;

    public BlockVoidChestPortal() {
        super(Material.field_151576_e);
        this.func_149663_c("voidChestPortal");
        this.func_149715_a(1.0f);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
    }

    @Override
    protected boolean displayInCreative() {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public boolean canEntityDestroy(IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180634_a(World world, BlockPos blockPos, IBlockState iBlockState, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)entity;
            if (world.field_73011_w.func_177502_q() == 68) {
                if (AOTDPlayerData.get((EntityPlayer)entityPlayer).isResearched(ResearchTypes.VoidChest)) {
                    Utility.sendPlayerToDimension(entityPlayer, 0, false, VoidChestTeleporter.class);
                }
            } else if (world.field_73011_w.func_177502_q() == 0) {
                if (AOTDPlayerData.get((EntityPlayer)entityPlayer).canResearch(ResearchTypes.VoidChest)) {
                    AOTDPlayerData.get((EntityPlayer)entityPlayer).unlockResearch(ResearchTypes.VoidChest, true);
                    AOTDPlayerData.get((EntityPlayer)entityPlayer).unlockResearch(ResearchTypes.EldritchDecoration, true);
                }
                if (AOTDPlayerData.get((EntityPlayer)entityPlayer).isResearched(ResearchTypes.VoidChest)) {
                    Utility.sendPlayerToVoidChest(entityPlayer, this.validatePlayerLocationVoidChest(AOTDPlayerData.get((EntityPlayer)entityPlayer).getPlayerLocationVoidChest(), (EntityPlayer)entityPlayer));
                } else if (System.currentTimeMillis() - this.lastTimeEntered > 3000L) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("This mysterious block could become more useful later. I should write down the location of this place."));
                    this.lastTimeEntered = System.currentTimeMillis();
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_180665_b(World worldIn, BlockPos pos) {
        return null;
    }

    private int validatePlayerLocationVoidChest(int locationX, EntityPlayer entityPlayer) {
        if (locationX == 0) {
            if (!entityPlayer.field_70170_p.field_72995_K) {
                MinecraftServer.func_71276_C().func_71187_D().func_71556_a((ICommandSender)MinecraftServer.func_71276_C(), "/save-all");
            }
            int furthestOutPlayer = 0;
            for (NBTTagCompound entityPlayerData : NBTHelper.getOfflinePlayerNBTs()) {
                furthestOutPlayer = Math.max(furthestOutPlayer, AOTDPlayerData.getPlayerLocationVoidChestOffline(entityPlayerData));
            }
            AOTDPlayerData.get(entityPlayer).setPlayerLocationVoidChest(furthestOutPlayer + 1);
        }
        return AOTDPlayerData.get(entityPlayer).getPlayerLocationVoidChest();
    }
}

