/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.animation;

import com.DavidM1A2.AfraidOfTheDark.client.MCAClientLibrary.MCAModelRenderer;
import com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.IMCAnimatedEntity;
import com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.animation.AnimTickHandler;
import com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.animation.Channel;
import com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.animation.CustomChannel;
import com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.animation.KeyFrame;
import com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.math.Quaternion;
import com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.math.Vector3f;
import com.DavidM1A2.AfraidOfTheDark.common.utility.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AnimationHandler {
    public static AnimTickHandler animTickHandler = new AnimTickHandler();
    private IMCAnimatedEntity animatedEntity;
    public List<Channel> animCurrentChannels = new ArrayList<Channel>();
    public HashMap<String, Long> animPrevTime = new HashMap();
    public HashMap<String, Float> animCurrentFrame = new HashMap();

    public AnimationHandler(IMCAnimatedEntity entity) {
        animTickHandler.addEntity(entity);
        this.animatedEntity = entity;
    }

    public IMCAnimatedEntity getEntity() {
        return this.animatedEntity;
    }

    public void activateAnimation(HashMap<String, Channel> animChannels, String name, float startingFrame) {
        if (animChannels.get(name) != null) {
            Channel selectedChannel = animChannels.get(name);
            int indexToRemove = this.animCurrentChannels.indexOf(selectedChannel);
            if (indexToRemove != -1) {
                this.animCurrentChannels.remove(indexToRemove);
            }
            this.animCurrentChannels.add(selectedChannel);
            this.animPrevTime.put(name, System.nanoTime());
            this.animCurrentFrame.put(name, Float.valueOf(startingFrame));
        } else {
            System.out.println("The animation called " + name + " doesn't exist!");
        }
    }

    public abstract void activateAnimation(String var1, float var2);

    public void stopAnimation(HashMap<String, Channel> animChannels, String name) {
        Channel selectedChannel = animChannels.get(name);
        if (selectedChannel != null) {
            int indexToRemove = this.animCurrentChannels.indexOf(selectedChannel);
            if (indexToRemove != -1) {
                this.animCurrentChannels.remove(indexToRemove);
                this.animPrevTime.remove(name);
                this.animCurrentFrame.remove(name);
            }
        } else {
            System.out.println("The animation called " + name + " doesn't exist!");
        }
    }

    public abstract void stopAnimation(String var1);

    public void animationsUpdate() {
        Iterator<Channel> it = this.animCurrentChannels.iterator();
        while (it.hasNext()) {
            Channel anim = it.next();
            if (this.animCurrentFrame == null) {
                LogHelper.info("animCurrentFrame = null");
            }
            if (anim == null) {
                LogHelper.info("anim = null");
            }
            float prevFrame = this.animCurrentFrame.get(anim.name).floatValue();
            boolean animStatus = AnimationHandler.updateAnimation(this.animatedEntity, anim, this.animPrevTime, this.animCurrentFrame);
            if (animStatus) continue;
            it.remove();
            this.animPrevTime.remove(anim.name);
            this.animCurrentFrame.remove(anim.name);
        }
    }

    public boolean isAnimationActive(String name) {
        for (Channel anim : this.animatedEntity.getAnimationHandler().animCurrentChannels) {
            if (!anim.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean updateAnimation(IMCAnimatedEntity entity, Channel channel, HashMap<String, Long> prevTimeAnim, HashMap<String, Float> prevFrameAnim) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() || FMLCommonHandler.instance().getEffectiveSide().isClient() && !AnimationHandler.isGamePaused()) {
            if (channel.mode != 3) {
                long currentTime;
                double deltaTime;
                float numberOfSkippedFrames;
                long prevTime = prevTimeAnim.get(channel.name);
                float prevFrame = prevFrameAnim.get(channel.name).floatValue();
                float currentFrame = prevFrame + (numberOfSkippedFrames = (float)((deltaTime = (double)((currentTime = System.nanoTime()) - prevTime) / 1.0E9) * (double)channel.fps));
                if (currentFrame < (float)(channel.totalFrames - 1)) {
                    prevTimeAnim.put(channel.name, currentTime);
                    prevFrameAnim.put(channel.name, Float.valueOf(currentFrame));
                    return true;
                }
                if (channel.mode == 1) {
                    prevTimeAnim.put(channel.name, currentTime);
                    prevFrameAnim.put(channel.name, Float.valueOf(0.0f));
                    return true;
                }
                return false;
            }
            return true;
        }
        long currentTime = System.nanoTime();
        prevTimeAnim.put(channel.name, currentTime);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isGamePaused() {
        Minecraft MC = Minecraft.func_71410_x();
        return MC.func_71356_B() && MC.field_71462_r != null && MC.field_71462_r.func_73868_f() && !MC.func_71401_C().func_71344_c();
    }

    @SideOnly(value=Side.CLIENT)
    public static void performAnimationInModel(HashMap<String, MCAModelRenderer> parts, IMCAnimatedEntity entity) {
        for (Map.Entry<String, MCAModelRenderer> entry : parts.entrySet()) {
            String boxName = entry.getKey();
            MCAModelRenderer box = entry.getValue();
            boolean anyRotationApplied = false;
            boolean anyTranslationApplied = false;
            boolean anyCustomAnimationRunning = false;
            for (Channel channel : entity.getAnimationHandler().animCurrentChannels) {
                if (channel.mode != 3) {
                    Vector3f currentPosition;
                    Vector3f endPosition;
                    Vector3f startPosition;
                    Quaternion currentQuat;
                    KeyFrame nextRotationKeyFrame;
                    int nextRotationKeyFramePosition;
                    KeyFrame prevRotationKeyFrame;
                    int prevRotationKeyFramePosition;
                    float currentFrame = entity.getAnimationHandler().animCurrentFrame.get(channel.name).floatValue();
                    float SLERPProgress = (currentFrame - (float)(prevRotationKeyFramePosition = (prevRotationKeyFrame = channel.getPreviousRotationKeyFrameForBox(boxName, entity.getAnimationHandler().animCurrentFrame.get(channel.name).floatValue())) != null ? channel.getKeyFramePosition(prevRotationKeyFrame) : 0)) / (float)((nextRotationKeyFramePosition = (nextRotationKeyFrame = channel.getNextRotationKeyFrameForBox(boxName, entity.getAnimationHandler().animCurrentFrame.get(channel.name).floatValue())) != null ? channel.getKeyFramePosition(nextRotationKeyFrame) : 0) - prevRotationKeyFramePosition);
                    if (SLERPProgress > 1.0f || SLERPProgress < 0.0f) {
                        SLERPProgress = 1.0f;
                    }
                    if (prevRotationKeyFramePosition == 0 && prevRotationKeyFrame == null && nextRotationKeyFramePosition != 0) {
                        currentQuat = new Quaternion();
                        currentQuat.slerp(parts.get(boxName).getDefaultRotationAsQuaternion(), nextRotationKeyFrame.modelRenderersRotations.get(boxName), SLERPProgress);
                        box.getRotationMatrix().set(currentQuat).transpose();
                        anyRotationApplied = true;
                    } else if (prevRotationKeyFramePosition == 0 && prevRotationKeyFrame != null && nextRotationKeyFramePosition != 0) {
                        currentQuat = new Quaternion();
                        currentQuat.slerp(prevRotationKeyFrame.modelRenderersRotations.get(boxName), nextRotationKeyFrame.modelRenderersRotations.get(boxName), SLERPProgress);
                        box.getRotationMatrix().set(currentQuat).transpose();
                        anyRotationApplied = true;
                    } else if (prevRotationKeyFramePosition != 0 && nextRotationKeyFramePosition != 0) {
                        currentQuat = new Quaternion();
                        currentQuat.slerp(prevRotationKeyFrame.modelRenderersRotations.get(boxName), nextRotationKeyFrame.modelRenderersRotations.get(boxName), SLERPProgress);
                        box.getRotationMatrix().set(currentQuat).transpose();
                        anyRotationApplied = true;
                    }
                    KeyFrame prevTranslationKeyFrame = channel.getPreviousTranslationKeyFrameForBox(boxName, entity.getAnimationHandler().animCurrentFrame.get(channel.name).floatValue());
                    int prevTranslationsKeyFramePosition = prevTranslationKeyFrame != null ? channel.getKeyFramePosition(prevTranslationKeyFrame) : 0;
                    KeyFrame nextTranslationKeyFrame = channel.getNextTranslationKeyFrameForBox(boxName, entity.getAnimationHandler().animCurrentFrame.get(channel.name).floatValue());
                    int nextTranslationsKeyFramePosition = nextTranslationKeyFrame != null ? channel.getKeyFramePosition(nextTranslationKeyFrame) : 0;
                    float LERPProgress = (currentFrame - (float)prevTranslationsKeyFramePosition) / (float)(nextTranslationsKeyFramePosition - prevTranslationsKeyFramePosition);
                    if (LERPProgress > 1.0f) {
                        LERPProgress = 1.0f;
                    }
                    if (prevTranslationsKeyFramePosition == 0 && prevTranslationKeyFrame == null && nextTranslationsKeyFramePosition != 0) {
                        startPosition = parts.get(boxName).getPositionAsVector();
                        endPosition = nextTranslationKeyFrame.modelRenderersTranslations.get(boxName);
                        currentPosition = new Vector3f(startPosition);
                        currentPosition.interpolate(endPosition, LERPProgress);
                        box.func_78793_a(currentPosition.x, currentPosition.y, currentPosition.z);
                        anyTranslationApplied = true;
                        continue;
                    }
                    if (prevTranslationsKeyFramePosition == 0 && prevTranslationKeyFrame != null && nextTranslationsKeyFramePosition != 0) {
                        startPosition = prevTranslationKeyFrame.modelRenderersTranslations.get(boxName);
                        endPosition = nextTranslationKeyFrame.modelRenderersTranslations.get(boxName);
                        currentPosition = new Vector3f(startPosition);
                        currentPosition.interpolate(endPosition, LERPProgress);
                        box.func_78793_a(currentPosition.x, currentPosition.y, currentPosition.z);
                        continue;
                    }
                    if (prevTranslationsKeyFramePosition == 0 || nextTranslationsKeyFramePosition == 0) continue;
                    startPosition = prevTranslationKeyFrame.modelRenderersTranslations.get(boxName);
                    endPosition = nextTranslationKeyFrame.modelRenderersTranslations.get(boxName);
                    currentPosition = new Vector3f(startPosition);
                    currentPosition.interpolate(endPosition, LERPProgress);
                    box.func_78793_a(currentPosition.x, currentPosition.y, currentPosition.z);
                    anyTranslationApplied = true;
                    continue;
                }
                anyCustomAnimationRunning = true;
                ((CustomChannel)channel).update(parts, entity);
            }
            if (!anyRotationApplied && !anyCustomAnimationRunning) {
                box.resetRotationMatrix();
            }
            if (anyTranslationApplied || anyCustomAnimationRunning) continue;
            box.resetRotationPoint();
        }
    }
}

