/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.animation;

import com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.IMCAnimatedEntity;
import com.DavidM1A2.AfraidOfTheDark.common.handler.ConfigurationHandler;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AnimTickHandler {
    private CopyOnWriteArrayList<IMCAnimatedEntity> activeEntities = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<IMCAnimatedEntity> removableEntities = new CopyOnWriteArrayList();

    public AnimTickHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void addEntity(IMCAnimatedEntity entity) {
        if (ConfigurationHandler.enableAOTDAnimations) {
            this.activeEntities.add(entity);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!this.activeEntities.isEmpty() && event.phase == TickEvent.Phase.START) {
            for (IMCAnimatedEntity entity : this.activeEntities) {
                entity.getAnimationHandler().animationsUpdate();
                if (!((Entity)entity).field_70128_L) continue;
                this.removableEntities.add(entity);
            }
            for (IMCAnimatedEntity entity : this.removableEntities) {
                this.activeEntities.remove(entity);
            }
            this.removableEntities.clear();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!this.activeEntities.isEmpty() && event.phase == TickEvent.Phase.START) {
            for (IMCAnimatedEntity entity : this.activeEntities) {
                entity.getAnimationHandler().animationsUpdate();
                if (!((Entity)entity).field_70128_L) continue;
                this.removableEntities.add(entity);
            }
            for (IMCAnimatedEntity entity : this.removableEntities) {
                this.activeEntities.remove(entity);
            }
            this.removableEntities.clear();
        }
    }
}

