/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls;

import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.AOTDGuiTextComponent;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.TextAlignment;
import com.DavidM1A2.AfraidOfTheDark.client.trueTypeFont.TrueTypeFont;
import com.DavidM1A2.AfraidOfTheDark.common.utility.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

public class AOTDGuiTextBox
extends AOTDGuiTextComponent {
    private List<String> textLines = new ArrayList<String>();
    private final int maxCharsPerLine;

    public AOTDGuiTextBox(int x, int y, int width, int height, TrueTypeFont font, int maxCharsPerLine) {
        super(x, y, width, height, font);
        this.maxCharsPerLine = maxCharsPerLine;
    }

    @Override
    public void setText(String textInput) {
        this.textLines.clear();
        StringTokenizer tok = new StringTokenizer(textInput, " ");
        int lineWidth = 0;
        int currentLineIndex = 0;
        while (tok.hasMoreTokens()) {
            String word = StringUtils.replace((String)tok.nextToken(), (String)"\t", (String)"   ");
            int nextLineLength = lineWidth + word.length() + 1;
            if (nextLineLength > this.maxCharsPerLine) {
                ++currentLineIndex;
                lineWidth = word.length() + 1;
                nextLineLength = word.length() + 1;
            }
            if (Utility.hasIndex(this.textLines, currentLineIndex)) {
                this.textLines.set(currentLineIndex, this.textLines.get(currentLineIndex) + word + " ");
            } else {
                this.textLines.add(word + " ");
            }
            lineWidth = nextLineLength;
        }
    }

    @Override
    public String getText() {
        return StringUtils.join((Object[])this.textLines.toArray());
    }

    @Override
    public void draw() {
        if (this.isVisible()) {
            super.draw();
            GL11.glPushMatrix();
            GL11.glScaled((double)this.getScaleX(), (double)this.getScaleY(), (double)1.0);
            for (int i = 0; i < this.textLines.size(); ++i) {
                this.getFont().drawString((float)this.getX(), (float)(this.getY() + i * (this.getFont().getFontSize() / 3)), this.textLines.get(i), this.textScaleConstant, this.textScaleConstant, TextAlignment.ALIGN_LEFT, this.getTextColor()[0], this.getTextColor()[1], this.getTextColor()[2], this.getTextColor()[3]);
            }
            GL11.glPopMatrix();
        }
    }

    public String getOverflowText(String text) {
        String toReturn = "";
        StringTokenizer tok = new StringTokenizer(text, " ");
        int lineWidth = 0;
        int currentLineIndex = 0;
        while (tok.hasMoreTokens()) {
            String word = StringUtils.replace((String)tok.nextToken(), (String)"\t", (String)"   ");
            int nextLineLength = lineWidth + word.length() + 1;
            if (word.contains("   ")) {
                nextLineLength += 2;
            }
            if (nextLineLength > this.maxCharsPerLine) {
                ++currentLineIndex;
                lineWidth = word.length() + 1;
                nextLineLength = word.length() + 1;
            }
            if ((double)((float)currentLineIndex * this.getFont().getHeight()) * 0.25 > (double)this.getHeight()) {
                toReturn = toReturn.isEmpty() ? word : toReturn + " " + word;
            }
            lineWidth = nextLineLength;
        }
        return toReturn;
    }
}

