/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls;

import com.DavidM1A2.AfraidOfTheDark.client.gui.AOTDActionListener;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.AOTDGuiComponent;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.AOTDGuiImage;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.AOTDGuiItemStack;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.AOTDGuiPanel;
import com.DavidM1A2.AfraidOfTheDark.common.recipe.ConvertedRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class AOTDGuiRecipe
extends AOTDGuiPanel {
    private final AOTDGuiImage CRAFTING_GRID;
    private final AOTDGuiItemStack[] guiItemStacks;
    private final AOTDGuiItemStack output;
    private final AOTDGuiImage itemStackHighlight;

    public AOTDGuiRecipe(int x, int y, int width, int height, ConvertedRecipe recipe) {
        super(x, y, width, height, false);
        int i;
        this.CRAFTING_GRID = new AOTDGuiImage(0, 0, width, height, "textures/gui/journalCrafting2.png");
        this.add(this.CRAFTING_GRID);
        this.itemStackHighlight = new AOTDGuiImage(0, 0, 0, 0, "textures/gui/slotHighlight.png");
        this.itemStackHighlight.setVisible(false);
        this.itemStackHighlight.addActionListener(new AOTDActionListener(){

            @Override
            public void actionPerformed(AOTDGuiComponent component, AOTDActionListener.ActionType actionType) {
                if (actionType == AOTDActionListener.ActionType.MouseEnterBoundingBox) {
                    component.setVisible(true);
                } else if (actionType == AOTDActionListener.ActionType.MouseExitBoundingBox) {
                    component.setVisible(false);
                }
            }
        });
        this.add(this.itemStackHighlight);
        this.guiItemStacks = new AOTDGuiItemStack[9];
        AOTDActionListener onItemHover = new AOTDActionListener(){

            @Override
            public void actionPerformed(AOTDGuiComponent component, AOTDActionListener.ActionType actionType) {
                ItemStack itemStack;
                if (actionType == AOTDActionListener.ActionType.MouseHover && component instanceof AOTDGuiItemStack && component.isVisible() && AOTDGuiRecipe.this.isVisible() && (itemStack = ((AOTDGuiItemStack)component).getItemStack()) != null) {
                    AOTDGuiRecipe.this.itemStackHighlight.setX(component.getX());
                    AOTDGuiRecipe.this.itemStackHighlight.setY(component.getY());
                    AOTDGuiRecipe.this.itemStackHighlight.setWidth(component.getWidth());
                    AOTDGuiRecipe.this.itemStackHighlight.setHeight(component.getHeight());
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(itemStack.func_82833_r() + " x" + itemStack.field_77994_a, (float)component.getXScaled(), (float)(component.getYScaled() - 5), -1);
                }
            }
        };
        for (i = 0; i < this.guiItemStacks.length; ++i) {
            this.guiItemStacks[i] = new AOTDGuiItemStack(5 + i % 3 * 24, 6 + 26 * (i > 5 ? 2 : (i > 2 ? 1 : 0)), (int)((double)width / 5.0), (int)((double)height / 4.0), null);
        }
        this.output = new AOTDGuiItemStack(83, 31, 24, 24, null);
        this.output.addActionListener(onItemHover);
        for (i = 0; i < this.guiItemStacks.length; ++i) {
            this.guiItemStacks[i].addActionListener(onItemHover);
            this.add(this.guiItemStacks[i]);
        }
        this.add(this.output);
        this.setRecipe(recipe);
    }

    @Override
    public void draw() {
        if (this.isVisible() && this.output.getItemStack() != null) {
            super.draw();
        }
    }

    public void setRecipe(ConvertedRecipe recipe) {
        int i;
        if (recipe == null) {
            this.output.setItemStack(null);
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        for (i = 0; i < this.guiItemStacks.length; ++i) {
            this.guiItemStacks[i].setItemStack(null);
        }
        if (recipe.getWidth() == -1) {
            for (i = 0; i < recipe.getInput().length; ++i) {
                this.guiItemStacks[i].setItemStack(recipe.getInput()[i]);
            }
        } else {
            for (i = 0; i < recipe.getHeight(); ++i) {
                for (int j = 0; j < recipe.getWidth(); ++j) {
                    this.guiItemStacks[i * 3 + j].setItemStack(recipe.getInput()[i * recipe.getWidth() + j]);
                }
            }
        }
        this.output.setItemStack(recipe.getOutput());
    }

    @Override
    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        this.itemStackHighlight.setVisible(false);
    }
}

